/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.http.client;

import dev.snowdrop.vertx.http.client.VertxClientHttpRequest;
import dev.snowdrop.vertx.http.client.VertxClientHttpResponse;
import dev.snowdrop.vertx.http.utils.BufferConverter;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class VertxClientHttpConnector
implements ClientHttpConnector {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final HttpClient httpClient;
    private final BufferConverter bufferConverter;

    public VertxClientHttpConnector(Vertx vertx) {
        this(vertx.createHttpClient());
    }

    public VertxClientHttpConnector(Vertx vertx, HttpClientOptions options) {
        this(vertx.createHttpClient(options));
    }

    public VertxClientHttpConnector(HttpClient httpClient) {
        Assert.notNull((Object)httpClient, (String)"HttpClient is required");
        this.httpClient = httpClient;
        this.bufferConverter = new BufferConverter();
    }

    public Mono<ClientHttpResponse> connect(HttpMethod method, URI uri, Function<? super ClientHttpRequest, Mono<Void>> requestCallback) {
        this.logger.debug("Connecting to '{}' with '{}", (Object)uri, (Object)method);
        if (!uri.isAbsolute()) {
            return Mono.error((Throwable)new IllegalArgumentException("URI is not absolute: " + uri));
        }
        CompletableFuture futureResponse = new CompletableFuture();
        HttpClientRequest request = this.httpClient.requestAbs(this.httpMethodAdapter(method), uri.toString()).handler(response -> futureResponse.complete(this.responseAdapter((HttpClientResponse)response))).exceptionHandler(futureResponse::completeExceptionally);
        return requestCallback.apply((ClientHttpRequest)this.requestAdapter(request)).then(Mono.fromCompletionStage(futureResponse));
    }

    private ClientHttpRequest requestAdapter(HttpClientRequest request) {
        return new VertxClientHttpRequest(request, this.bufferConverter);
    }

    private ClientHttpResponse responseAdapter(HttpClientResponse response) {
        return new VertxClientHttpResponse(response, this.bufferConverter);
    }

    private io.vertx.core.http.HttpMethod httpMethodAdapter(HttpMethod method) {
        return io.vertx.core.http.HttpMethod.valueOf((String)method.name());
    }
}

