/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.http.server;

import dev.snowdrop.vertx.http.common.ReadStreamFluxBuilder;
import dev.snowdrop.vertx.http.server.SslInfoImpl;
import dev.snowdrop.vertx.http.utils.BufferConverter;
import dev.snowdrop.vertx.http.utils.CookieConverter;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.web.RoutingContext;
import java.net.InetSocketAddress;
import java.net.URI;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.AbstractServerHttpRequest;
import org.springframework.http.server.reactive.SslInfo;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;

public class VertxServerHttpRequest
extends AbstractServerHttpRequest {
    private final RoutingContext context;
    private final HttpServerRequest delegate;
    private final Flux<DataBuffer> bodyFlux;

    public VertxServerHttpRequest(RoutingContext context, BufferConverter bufferConverter) {
        super(VertxServerHttpRequest.initUri(context.request()), "", VertxServerHttpRequest.initHeaders(context.request()));
        this.context = context;
        this.delegate = context.request();
        this.bodyFlux = new ReadStreamFluxBuilder().readStream(this.delegate).dataConverter(bufferConverter::toDataBuffer).build();
    }

    public <T> T getNativeRequest() {
        return (T)this.delegate;
    }

    public String getMethodValue() {
        return this.delegate.method().name();
    }

    public Flux<DataBuffer> getBody() {
        return this.bodyFlux;
    }

    public InetSocketAddress getRemoteAddress() {
        SocketAddress address = this.delegate.remoteAddress();
        if (address == null) {
            return null;
        }
        return new InetSocketAddress(address.host(), address.port());
    }

    protected MultiValueMap<String, HttpCookie> initCookies() {
        LinkedMultiValueMap cookies = new LinkedMultiValueMap();
        this.context.cookies().stream().map(CookieConverter::toHttpCookie).forEach(arg_0 -> VertxServerHttpRequest.lambda$initCookies$0((MultiValueMap)cookies, arg_0));
        return cookies;
    }

    protected SslInfo initSslInfo() {
        if (this.delegate.sslSession() == null) {
            return null;
        }
        return new SslInfoImpl(this.delegate.sslSession());
    }

    private static URI initUri(HttpServerRequest request) {
        return URI.create(request.absoluteURI());
    }

    private static HttpHeaders initHeaders(HttpServerRequest request) {
        HttpHeaders headers = new HttpHeaders();
        request.headers().forEach(e -> headers.add((String)e.getKey(), (String)e.getValue()));
        return headers;
    }

    private static /* synthetic */ void lambda$initCookies$0(MultiValueMap cookies, HttpCookie cookie) {
        cookies.add((Object)cookie.getName(), (Object)cookie);
    }
}

