/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.http.server;

import dev.snowdrop.vertx.http.server.VertxReactiveWebServerFactory;
import dev.snowdrop.vertx.http.server.VertxReactiveWebServerFactoryCustomizer;
import dev.snowdrop.vertx.http.server.VertxRequestUpgradeStrategy;
import dev.snowdrop.vertx.http.server.properties.HttpServerOptionsCustomizer;
import dev.snowdrop.vertx.http.server.properties.HttpServerProperties;
import io.vertx.core.Vertx;
import java.util.Set;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.reactive.server.ReactiveWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.ReactiveHttpInputMessage;
import org.springframework.web.reactive.socket.server.RequestUpgradeStrategy;
import org.springframework.web.reactive.socket.server.WebSocketService;
import org.springframework.web.reactive.socket.server.support.HandshakeWebSocketService;
import org.springframework.web.reactive.socket.server.support.WebSocketHandlerAdapter;

@Configuration
@AutoConfigureOrder(value=-2147483648)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnClass(value={ReactiveHttpInputMessage.class})
@ConditionalOnMissingBean(value={ReactiveWebServerFactory.class})
@EnableConfigurationProperties(value={HttpServerProperties.class})
public class ServerAutoConfiguration {
    @Bean
    public VertxReactiveWebServerFactory vertxReactiveWebServerFactory(Vertx vertx, HttpServerProperties properties) {
        return new VertxReactiveWebServerFactory(vertx, properties);
    }

    @Bean
    public VertxReactiveWebServerFactoryCustomizer vertxWebServerFactoryCustomizer(Set<HttpServerOptionsCustomizer> userDefinedCustomizers) {
        return new VertxReactiveWebServerFactoryCustomizer(userDefinedCustomizers);
    }

    @Bean
    public WebSocketService webSocketService() {
        VertxRequestUpgradeStrategy requestUpgradeStrategy = new VertxRequestUpgradeStrategy();
        return new HandshakeWebSocketService((RequestUpgradeStrategy)requestUpgradeStrategy);
    }

    @Bean
    public WebSocketHandlerAdapter webSocketHandlerAdapter(WebSocketService webSocketService) {
        return new WebSocketHandlerAdapter(webSocketService);
    }
}

