/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.http.client;

import dev.snowdrop.vertx.http.common.VertxWebSocketSession;
import dev.snowdrop.vertx.http.utils.BufferConverter;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketBase;
import io.vertx.core.http.impl.headers.VertxHttpHeaders;
import java.net.URI;
import org.springframework.http.HttpHeaders;
import org.springframework.util.Assert;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.WebSocketSession;
import org.springframework.web.reactive.socket.client.WebSocketClient;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public class VertxWebSocketClient
implements WebSocketClient {
    private final Vertx vertx;
    private final HttpClientOptions clientOptions;
    private final BufferConverter bufferConverter;

    public VertxWebSocketClient(Vertx vertx) {
        Assert.notNull((Object)vertx, (String)"Vertx is required");
        this.vertx = vertx;
        this.clientOptions = new HttpClientOptions();
        this.bufferConverter = new BufferConverter();
    }

    public VertxWebSocketClient(Vertx vertx, HttpClientOptions options) {
        Assert.notNull((Object)vertx, (String)"Vertx is required");
        this.vertx = vertx;
        this.clientOptions = options;
        this.bufferConverter = new BufferConverter();
    }

    public Mono<Void> execute(URI uri, WebSocketHandler handler) {
        return this.execute(uri, new HttpHeaders(), handler);
    }

    public Mono<Void> execute(URI uri, HttpHeaders headers, WebSocketHandler handler) {
        VertxHttpHeaders vertxHeaders = this.convertHeaders(headers);
        return Mono.create(sink -> this.connect(uri, vertxHeaders, handler, (MonoSink<Void>)sink));
    }

    private void connect(URI uri, VertxHttpHeaders headers, WebSocketHandler handler, MonoSink<Void> callback) {
        HttpClient client = this.vertx.createHttpClient(this.clientOptions);
        client.websocket(uri.getPort(), uri.getHost(), uri.getPath(), (MultiMap)headers, socket -> handler.handle((WebSocketSession)this.initSession(uri, (WebSocket)socket)).doOnSuccess(arg_0 -> ((MonoSink)callback).success(arg_0)).doOnError(arg_0 -> ((MonoSink)callback).error(arg_0)).doFinally(ignore -> client.close()).subscribe(), arg_0 -> callback.error(arg_0));
    }

    private VertxHttpHeaders convertHeaders(HttpHeaders headers) {
        VertxHttpHeaders vertxHeaders = new VertxHttpHeaders();
        headers.forEach((arg_0, arg_1) -> ((VertxHttpHeaders)vertxHeaders).add(arg_0, arg_1));
        return vertxHeaders;
    }

    private VertxWebSocketSession initSession(URI uri, WebSocket socket) {
        HandshakeInfo handshakeInfo = new HandshakeInfo(uri, new HttpHeaders(), Mono.empty(), socket.subProtocol());
        return new VertxWebSocketSession((WebSocketBase)socket, handshakeInfo, this.bufferConverter);
    }
}

