/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.http.common;

import io.vertx.core.streams.WriteStream;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.BaseSubscriber;
import reactor.core.publisher.MonoSink;

public class WriteStreamSubscriber<T extends WriteStream<?>, U>
extends BaseSubscriber<U> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final T writeStream;
    private final BiConsumer<T, U> nextHandler;
    private final MonoSink<Void> endHook;
    private final String logPrefix;

    private WriteStreamSubscriber(T writeStream, BiConsumer<T, U> nextHandler, MonoSink<Void> endHook) {
        this.writeStream = writeStream;
        this.nextHandler = nextHandler;
        this.endHook = endHook;
        this.logPrefix = "[" + ObjectUtils.getIdentityHexString(writeStream) + "] ";
        writeStream.exceptionHandler(this::exceptionHandler);
    }

    protected void hookOnSubscribe(Subscription subscription) {
        this.logger.debug("{}{} subscribed", (Object)this.logPrefix, this.writeStream);
        this.requestIfNotFull();
        this.writeStream.drainHandler(event -> this.requestIfNotFull());
    }

    protected void hookOnNext(U value) {
        this.logger.debug("{}Next: {}", (Object)this.logPrefix, value);
        this.nextHandler.accept(this.writeStream, value);
        this.requestIfNotFull();
    }

    protected void hookOnComplete() {
        this.logger.debug("{}Completed", (Object)this.logPrefix);
        this.endHook.success();
    }

    protected void hookOnCancel() {
        this.logger.debug("{}Canceled", (Object)this.logPrefix);
        this.endHook.success();
    }

    protected void hookOnError(Throwable throwable) {
        this.logger.debug("{}Error: {}", (Object)this.logPrefix, (Object)throwable);
        this.endHook.error(throwable);
    }

    private void exceptionHandler(Throwable ignored) {
        this.cancel();
    }

    private void requestIfNotFull() {
        if (!this.writeStream.writeQueueFull()) {
            this.logger.debug("{}Requesting more data", (Object)this.logPrefix);
            this.request(1L);
        }
    }

    /* synthetic */ WriteStreamSubscriber(WriteStream x0, BiConsumer x1, MonoSink x2, 1 x3) {
        this(x0, x1, (MonoSink<Void>)x2);
    }

    public static class Builder<T extends WriteStream<?>, U> {
        private T writeStream;
        private BiConsumer<T, U> nextHandler;
        private MonoSink<Void> endHook;

        public Builder<T, U> writeStream(T writeStream) {
            this.writeStream = writeStream;
            return this;
        }

        public Builder<T, U> nextHandler(BiConsumer<T, U> nextHandler) {
            this.nextHandler = nextHandler;
            return this;
        }

        public Builder<T, U> endHook(MonoSink<Void> endHook) {
            this.endHook = endHook;
            return this;
        }

        public WriteStreamSubscriber<T, U> build() {
            Objects.requireNonNull(this.writeStream, "Write stream is required");
            Objects.requireNonNull(this.nextHandler, "Next handler is required");
            Objects.requireNonNull(this.endHook, "End hook is required");
            return new WriteStreamSubscriber((WriteStream)this.writeStream, this.nextHandler, (MonoSink)this.endHook, null);
        }
    }
}

