/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.http.server;

import dev.snowdrop.vertx.http.server.VertxServerHttpRequest;
import dev.snowdrop.vertx.http.server.VertxServerHttpResponse;
import dev.snowdrop.vertx.http.utils.BufferConverter;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;

public class VertxHttpHandlerAdapter
implements Handler<RoutingContext> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final HttpHandler httpHandler;
    private final BufferConverter bufferConverter;

    public VertxHttpHandlerAdapter(HttpHandler httpHandler) {
        this.httpHandler = httpHandler;
        this.bufferConverter = new BufferConverter();
    }

    public void handle(RoutingContext context) {
        this.logger.debug("Adapting Vert.x server request to WebFlux request");
        VertxServerHttpRequest webFluxRequest = new VertxServerHttpRequest(context, this.bufferConverter);
        VertxServerHttpResponse webFluxResponse = new VertxServerHttpResponse(context, this.bufferConverter);
        this.httpHandler.handle((ServerHttpRequest)webFluxRequest, (ServerHttpResponse)webFluxResponse).doOnSuccess(v -> {
            this.logger.debug("Completed server request handling");
            if (!context.response().ended()) {
                context.response().end();
            }
        }).doOnError(throwable -> {
            this.logger.debug("Completed server request handling with an error '{}'", (Object)throwable.toString());
            context.response().setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR.value()).end();
        }).subscribe();
    }
}

