/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.http.client;

import dev.snowdrop.vertx.http.utils.CookieConverter;
import io.vertx.core.http.HttpClientResponse;
import java.util.Collection;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseCookie;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;

public class VertxClientHttpResponse
implements ClientHttpResponse {
    private final HttpClientResponse delegate;
    private final Flux<DataBuffer> body;

    public VertxClientHttpResponse(HttpClientResponse delegate, Flux<DataBuffer> body) {
        this.delegate = delegate;
        this.body = body;
    }

    public int getRawStatusCode() {
        return this.delegate.statusCode();
    }

    public HttpStatus getStatusCode() {
        return HttpStatus.valueOf((int)this.delegate.statusCode());
    }

    public Flux<DataBuffer> getBody() {
        return this.body;
    }

    public HttpHeaders getHeaders() {
        HttpHeaders headers = new HttpHeaders();
        this.delegate.headers().forEach(e -> headers.add((String)e.getKey(), (String)e.getValue()));
        return headers;
    }

    public MultiValueMap<String, ResponseCookie> getCookies() {
        LinkedMultiValueMap cookies = new LinkedMultiValueMap();
        this.delegate.cookies().stream().map(CookieConverter::toResponseCookies).flatMap(Collection::stream).forEach(arg_0 -> VertxClientHttpResponse.lambda$getCookies$1((MultiValueMap)cookies, arg_0));
        return cookies;
    }

    private static /* synthetic */ void lambda$getCookies$1(MultiValueMap cookies, ResponseCookie cookie) {
        cookies.add((Object)cookie.getName(), (Object)cookie);
    }
}

