/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.http.server;

import dev.snowdrop.vertx.http.server.VertxHttpHandlerAdapter;
import dev.snowdrop.vertx.http.server.VertxWebServer;
import dev.snowdrop.vertx.http.server.properties.HttpServerOptionsCustomizer;
import dev.snowdrop.vertx.http.server.properties.HttpServerProperties;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerOptions;
import java.util.LinkedList;
import java.util.List;
import org.springframework.boot.web.reactive.server.AbstractReactiveWebServerFactory;
import org.springframework.boot.web.server.WebServer;
import org.springframework.http.server.reactive.HttpHandler;

public class VertxReactiveWebServerFactory
extends AbstractReactiveWebServerFactory {
    private final Vertx vertx;
    private final HttpServerProperties properties;
    private final List<HttpServerOptionsCustomizer> httpServerOptionsCustomizers = new LinkedList<HttpServerOptionsCustomizer>();

    public VertxReactiveWebServerFactory(Vertx vertx, HttpServerProperties properties) {
        this.vertx = vertx;
        this.properties = properties;
    }

    public WebServer getWebServer(HttpHandler httpHandler) {
        HttpServerOptions httpServerOptions = this.customizeHttpServerOptions(this.properties.getHttpServerOptions());
        VertxHttpHandlerAdapter handler = new VertxHttpHandlerAdapter(httpHandler);
        return new VertxWebServer(this.vertx, httpServerOptions, handler);
    }

    public void registerHttpServerOptionsCustomizer(HttpServerOptionsCustomizer customizer) {
        this.httpServerOptionsCustomizers.add(customizer);
    }

    private HttpServerOptions customizeHttpServerOptions(HttpServerOptions httpServerOptions) {
        for (HttpServerOptionsCustomizer customizer : this.httpServerOptionsCustomizers) {
            httpServerOptions = (HttpServerOptions)customizer.apply(httpServerOptions);
        }
        return httpServerOptions;
    }
}

