/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.http.client;

import dev.snowdrop.vertx.http.common.WriteStreamSubscriber;
import dev.snowdrop.vertx.http.utils.BufferConverter;
import io.vertx.core.http.HttpClientRequest;
import java.net.URI;
import java.util.Collection;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.reactive.AbstractClientHttpRequest;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public class VertxClientHttpRequest
extends AbstractClientHttpRequest {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final HttpClientRequest delegate;
    private final BufferConverter bufferConverter;

    public VertxClientHttpRequest(HttpClientRequest delegate, BufferConverter bufferConverter) {
        this.delegate = delegate;
        this.bufferConverter = bufferConverter;
    }

    public HttpMethod getMethod() {
        return HttpMethod.resolve((String)this.delegate.method().name());
    }

    public URI getURI() {
        return URI.create(this.delegate.absoluteURI());
    }

    public <T> T getNativeRequest() {
        return (T)this.delegate;
    }

    public DataBufferFactory bufferFactory() {
        return this.bufferConverter.getDataBufferFactory();
    }

    public Mono<Void> writeWith(Publisher<? extends DataBuffer> chunks) {
        Mono writeCompletion = Mono.create(sink -> {
            this.logger.debug("Subscribing to body publisher");
            WriteStreamSubscriber<HttpClientRequest, DataBuffer> subscriber = new WriteStreamSubscriber.Builder().writeStream(this.delegate).endHook((MonoSink<Void>)sink).nextHandler((stream, value) -> stream.write(this.bufferConverter.toBuffer((DataBuffer)value))).build();
            chunks.subscribe(subscriber);
        });
        Mono endCompletion = Mono.create(sink -> {
            this.logger.debug("Completing request after writing");
            this.delegate.end();
            sink.success();
        });
        return this.doCommit(() -> writeCompletion.then(endCompletion));
    }

    public Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> chunks) {
        return this.writeWith((Publisher<? extends DataBuffer>)Flux.from(chunks).flatMap(Function.identity()));
    }

    public Mono<Void> setComplete() {
        return this.doCommit(() -> Mono.create(sink -> {
            this.logger.debug("Completing empty request");
            this.delegate.end();
            sink.success();
        }));
    }

    protected void applyHeaders() {
        HttpHeaders headers = this.getHeaders();
        if (!headers.containsKey((Object)"Content-Length")) {
            this.logger.debug("Setting chunked request");
            this.delegate.setChunked(true);
        }
        headers.forEach((arg_0, arg_1) -> ((HttpClientRequest)this.delegate).putHeader(arg_0, arg_1));
    }

    protected void applyCookies() {
        this.getCookies().values().stream().flatMap(Collection::stream).map(HttpCookie::toString).forEach(cookie -> this.delegate.putHeader("Cookie", cookie));
    }
}

