/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.http.client;

import dev.snowdrop.vertx.http.client.VertxClientHttpRequest;
import dev.snowdrop.vertx.http.client.VertxClientHttpResponse;
import dev.snowdrop.vertx.http.common.ReadStreamFluxBuilder;
import dev.snowdrop.vertx.http.utils.BufferConverter;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.RequestOptions;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class VertxClientHttpConnector
implements ClientHttpConnector {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final BufferConverter bufferConverter;
    private final Vertx vertx;
    private final HttpClientOptions clientOptions;

    public VertxClientHttpConnector(Vertx vertx) {
        Assert.notNull((Object)vertx, (String)"Vertx is required");
        this.bufferConverter = new BufferConverter();
        this.vertx = vertx;
        this.clientOptions = new HttpClientOptions();
    }

    public VertxClientHttpConnector(Vertx vertx, HttpClientOptions options) {
        Assert.notNull((Object)vertx, (String)"Vertx is required");
        this.bufferConverter = new BufferConverter();
        this.vertx = vertx;
        this.clientOptions = options;
    }

    public Mono<ClientHttpResponse> connect(HttpMethod method, URI uri, Function<? super ClientHttpRequest, Mono<Void>> requestCallback) {
        this.logger.debug("Connecting to '{}' with '{}", (Object)uri, (Object)method);
        if (!uri.isAbsolute()) {
            return Mono.error((Throwable)new IllegalArgumentException("URI is not absolute: " + uri));
        }
        CompletableFuture responseFuture = new CompletableFuture();
        HttpClient client = this.vertx.createHttpClient(this.clientOptions);
        RequestOptions requestOptions = new RequestOptions();
        try {
            requestOptions.setAbsoluteURI(uri.toURL());
            requestOptions.setMethod(io.vertx.core.http.HttpMethod.valueOf((String)method.name()));
        }
        catch (MalformedURLException e) {
            return Mono.error((Throwable)new IllegalArgumentException("URI is malformed: " + uri));
        }
        CompletableFuture requestFuture = new CompletableFuture();
        client.request(requestOptions).onFailure(requestFuture::completeExceptionally).onSuccess(request -> {
            request.response().onSuccess(response -> {
                Flux responseBody = this.responseToFlux((HttpClientResponse)response).doFinally(ignore -> client.close());
                responseFuture.complete(new VertxClientHttpResponse((HttpClientResponse)response, (Flux<DataBuffer>)responseBody));
            }).onFailure(responseFuture::completeExceptionally);
            requestFuture.complete(request);
        });
        return Mono.fromFuture(requestFuture).flatMap(request -> (Mono)requestCallback.apply((ClientHttpRequest)new VertxClientHttpRequest((HttpClientRequest)request, this.bufferConverter))).then(Mono.fromCompletionStage(responseFuture));
    }

    private Flux<DataBuffer> responseToFlux(HttpClientResponse response) {
        return new ReadStreamFluxBuilder().readStream(response).dataConverter(this.bufferConverter::toDataBuffer).build();
    }
}

