/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.http.server;

import dev.snowdrop.vertx.http.common.WriteStreamSubscriber;
import dev.snowdrop.vertx.http.utils.BufferConverter;
import dev.snowdrop.vertx.http.utils.CookieConverter;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.nio.file.Path;
import java.util.Collection;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ZeroCopyHttpOutputMessage;
import org.springframework.http.server.reactive.AbstractServerHttpResponse;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public class VertxServerHttpResponse
extends AbstractServerHttpResponse
implements ZeroCopyHttpOutputMessage {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final RoutingContext context;
    private final HttpServerResponse delegate;
    private final BufferConverter bufferConverter;

    public VertxServerHttpResponse(RoutingContext context, BufferConverter bufferConverter) {
        super((DataBufferFactory)bufferConverter.getDataBufferFactory(), VertxServerHttpResponse.initHeaders(context.response()));
        this.context = context;
        this.delegate = context.response();
        this.bufferConverter = bufferConverter;
    }

    public <T> T getNativeResponse() {
        return (T)this.delegate;
    }

    public Mono<Void> writeWith(Path file, long position, long count) {
        Mono writeCompletion = Mono.create(sink -> {
            this.logger.debug("Sending file '{}' pos='{}' count='{}'", new Object[]{file, position, count});
            this.delegate.sendFile(file.toString(), position, count, result -> {
                if (result.succeeded()) {
                    sink.success();
                } else {
                    sink.error(result.cause());
                }
            });
        });
        return this.doCommit(() -> writeCompletion);
    }

    protected Mono<Void> writeWithInternal(Publisher<? extends DataBuffer> chunks) {
        return Mono.create(sink -> {
            this.logger.debug("Subscribing to body publisher");
            WriteStreamSubscriber<HttpServerResponse, DataBuffer> subscriber = new WriteStreamSubscriber.Builder().writeStream(this.delegate).endHook((MonoSink<Void>)sink).nextHandler((stream, value) -> stream.write((Object)this.bufferConverter.toBuffer((DataBuffer)value))).build();
            chunks.subscribe(subscriber);
        });
    }

    protected Mono<Void> writeAndFlushWithInternal(Publisher<? extends Publisher<? extends DataBuffer>> chunks) {
        return this.writeWithInternal((Publisher<? extends DataBuffer>)Flux.from(chunks).flatMap(Function.identity()));
    }

    protected void applyStatusCode() {
        HttpStatus statusCode = this.getStatusCode();
        if (statusCode != null) {
            this.delegate.setStatusCode(statusCode.value());
        }
    }

    protected void applyHeaders() {
        HttpHeaders headers = this.getHeaders();
        if (!headers.containsKey((Object)"Content-Length")) {
            this.logger.debug("Setting chunked response");
            this.delegate.setChunked(true);
        }
        headers.forEach((arg_0, arg_1) -> ((HttpServerResponse)this.delegate).putHeader(arg_0, arg_1));
    }

    protected void applyCookies() {
        this.getCookies().values().stream().flatMap(Collection::stream).map(CookieConverter::toCookie).forEach(arg_0 -> ((RoutingContext)this.context).addCookie(arg_0));
    }

    private static HttpHeaders initHeaders(HttpServerResponse response) {
        HttpHeaders headers = new HttpHeaders();
        response.headers().forEach(e -> headers.add((String)e.getKey(), (String)e.getValue()));
        return headers;
    }
}

