/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.mail;

import dev.snowdrop.vertx.mail.MailAttachmentConverter;
import dev.snowdrop.vertx.mail.MailClient;
import dev.snowdrop.vertx.mail.MailMessageConverter;
import dev.snowdrop.vertx.mail.MailProperties;
import dev.snowdrop.vertx.mail.MailResultConverter;
import dev.snowdrop.vertx.mail.MultiMapConverter;
import dev.snowdrop.vertx.mail.VertxMailClient;
import io.vertx.core.Vertx;
import io.vertx.ext.mail.MailConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={MailProperties.class})
@ConditionalOnBean(value={Vertx.class})
@ConditionalOnProperty(prefix="vertx.mail", value={"enabled"}, matchIfMissing=true)
public class MailAutoConfiguration {
    @Bean
    public MailClient mailClient(Vertx vertx, MailProperties properties) {
        io.vertx.axle.core.Vertx axleVertx = new io.vertx.axle.core.Vertx(vertx);
        io.vertx.axle.ext.mail.MailClient axleMailClient = io.vertx.axle.ext.mail.MailClient.createNonShared((io.vertx.axle.core.Vertx)axleVertx, (MailConfig)properties.getMailConfig());
        return new VertxMailClient(axleMailClient, this.getMailMessageConverter(axleVertx), new MailResultConverter());
    }

    private MailMessageConverter getMailMessageConverter(io.vertx.axle.core.Vertx vertx) {
        MultiMapConverter multiMapConverter = new MultiMapConverter();
        MailAttachmentConverter mailAttachmentConverter = new MailAttachmentConverter(vertx, multiMapConverter);
        return new MailMessageConverter(mailAttachmentConverter, multiMapConverter);
    }
}

