/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.mail;

import dev.snowdrop.vertx.mail.MailAttachmentConverter;
import dev.snowdrop.vertx.mail.MailMessage;
import dev.snowdrop.vertx.mail.MultiMapConverter;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class MailMessageConverter {
    private final MailAttachmentConverter mailAttachmentConverter;
    private final MultiMapConverter multiMapConverter;

    MailMessageConverter(MailAttachmentConverter mailAttachmentConverter, MultiMapConverter multiMapConverter) {
        this.mailAttachmentConverter = mailAttachmentConverter;
        this.multiMapConverter = multiMapConverter;
    }

    Mono<io.vertx.ext.mail.MailMessage> toVertxMailMessage(MailMessage message) {
        io.vertx.ext.mail.MailMessage delegateMessage = new io.vertx.ext.mail.MailMessage();
        delegateMessage.setBounceAddress(message.getBounceAddress());
        delegateMessage.setFrom(message.getFrom());
        delegateMessage.setTo(message.getTo());
        delegateMessage.setCc(message.getCc());
        delegateMessage.setBcc(message.getBcc());
        delegateMessage.setSubject(message.getSubject());
        delegateMessage.setText(message.getText());
        delegateMessage.setHtml(message.getHtml());
        delegateMessage.setHeaders(this.multiMapConverter.fromMultiValueMap(message.getHeaders()));
        Mono attachmentsFuture = Flux.fromIterable(message.getAttachments()).flatMap(this.mailAttachmentConverter::toVertxMailAttachment).collectList().doOnNext(arg_0 -> ((io.vertx.ext.mail.MailMessage)delegateMessage).setAttachment(arg_0));
        Mono inlineAttachmentsFuture = Flux.fromIterable(message.getInlineAttachments()).flatMap(this.mailAttachmentConverter::toVertxMailAttachment).collectList().doOnNext(arg_0 -> ((io.vertx.ext.mail.MailMessage)delegateMessage).setInlineAttachment(arg_0));
        return Mono.zip((Mono)inlineAttachmentsFuture, (Mono)attachmentsFuture).thenReturn((Object)delegateMessage);
    }
}

