/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.mail;

import dev.snowdrop.vertx.mail.MailClient;
import dev.snowdrop.vertx.mail.MailMessage;
import dev.snowdrop.vertx.mail.MailMessageConverter;
import dev.snowdrop.vertx.mail.MailResult;
import dev.snowdrop.vertx.mail.MailResultConverter;
import io.smallrye.mutiny.converters.uni.UniReactorConverters;
import java.util.function.Function;
import reactor.core.publisher.Mono;

class VertxMailClient
implements MailClient {
    private final io.vertx.mutiny.ext.mail.MailClient delegate;
    private final MailMessageConverter mailMessageConverter;
    private final MailResultConverter mailResultConverter;

    VertxMailClient(io.vertx.mutiny.ext.mail.MailClient delegate, MailMessageConverter mailMessageConverter, MailResultConverter mailResultConverter) {
        this.delegate = delegate;
        this.mailMessageConverter = mailMessageConverter;
        this.mailResultConverter = mailResultConverter;
    }

    @Override
    public Mono<MailResult> send(MailMessage message) {
        return this.mailMessageConverter.toVertxMailMessage(message).flatMap(vertxMessage -> (Mono)this.delegate.sendMail(vertxMessage).convert().with((Function)UniReactorConverters.toMono())).map(this.mailResultConverter::fromVertxMailResult);
    }
}

