/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.mail;

import dev.snowdrop.vertx.mail.MailAttachment;
import dev.snowdrop.vertx.mail.MultiMapConverter;
import io.smallrye.mutiny.converters.multi.MultiReactorConverters;
import io.smallrye.mutiny.converters.uni.UniReactorConverters;
import io.vertx.core.file.OpenOptions;
import io.vertx.ext.mail.impl.MailAttachmentImpl;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.core.file.AsyncFile;
import java.io.File;
import java.util.function.Function;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class MailAttachmentConverter {
    private final Vertx vertx;
    private final MultiMapConverter multiMapConverter;
    private final MailAttachmentConverter mailAttachmentConverter = null;

    MailAttachmentConverter(Vertx vertx, MultiMapConverter multiMapConverter) {
        this.vertx = vertx;
        this.multiMapConverter = multiMapConverter;
    }

    Mono<io.vertx.ext.mail.MailAttachment> toVertxMailAttachment(MailAttachment attachment) {
        MailAttachmentImpl delegateAttachment = new MailAttachmentImpl();
        delegateAttachment.setName(attachment.getName());
        delegateAttachment.setContentType(attachment.getContentType());
        delegateAttachment.setDisposition(attachment.getDisposition());
        delegateAttachment.setDescription(attachment.getDescription());
        delegateAttachment.setContentId(attachment.getContentId());
        delegateAttachment.setHeaders(this.multiMapConverter.fromMultiValueMap(attachment.getHeaders()));
        if (attachment.getFile() != null) {
            return this.fileAttachmentToBuffer(attachment.getFile()).map(Buffer::getDelegate).map(arg_0 -> ((io.vertx.ext.mail.MailAttachment)delegateAttachment).setData(arg_0));
        }
        if (attachment.getData() != null) {
            return this.dataBufferAttachmentToBuffer(attachment.getData()).map(Buffer::getDelegate).map(arg_0 -> ((io.vertx.ext.mail.MailAttachment)delegateAttachment).setData(arg_0));
        }
        return Mono.error((Throwable)new IllegalArgumentException("Attachment has no data"));
    }

    private Mono<Buffer> dataBufferAttachmentToBuffer(Flux<DataBuffer> dataBufferStream) {
        return dataBufferStream.map(NettyDataBufferFactory::toByteBuf).map(Buffer::buffer).collect(Buffer::buffer, Buffer::appendBuffer);
    }

    private Mono<Buffer> fileAttachmentToBuffer(File file) {
        return ((Mono)this.vertx.fileSystem().open(file.getAbsolutePath(), new OpenOptions().setRead(true).setCreate(false)).convert().with((Function)UniReactorConverters.toMono())).flatMap(this::readAndCloseFile);
    }

    private Mono<Buffer> readAndCloseFile(AsyncFile asyncFile) {
        return ((Flux)asyncFile.toMulti().convert().with((Function)MultiReactorConverters.toFlux())).collect(Buffer::buffer, Buffer::appendBuffer).doOnTerminate(() -> ((AsyncFile)asyncFile).close());
    }
}

