/*
 * Decompiled with CFR 0.152.
 */
package dev.ssdd;

import dev.ssdd.EncryptoSpi;
import dev.ssdd.LocalFileEncryption;
import dev.ssdd.ZotKeyPair;
import dev.ssdd.ZotPublicKey;
import dev.ssdd.zot.JSONObject;
import java.util.Base64;

public class Encrypto {
    public static final String RSA = "RSA";
    public static final String DES = "DES";
    private final int bitLength;
    private final String algo;
    private EncryptoSpi ei;
    ZotKeyPair keyPair;
    private String pw;

    public Encrypto(String algo) {
        this.bitLength = 1024;
        this.algo = algo;
        this.init();
    }

    public Encrypto(String algo, int bitLength) {
        this.bitLength = bitLength;
        this.algo = algo;
        this.init();
    }

    public Encrypto(String algo, String password) {
        this.bitLength = 1024;
        this.algo = algo;
        this.pw = password;
        this.init();
    }

    private void init() {
        String link = "https://github.com/ssddcodes/encrypto/";
        if (this.algo.equalsIgnoreCase(DES)) {
            if (this.pw == null || this.pw.length() < 8) {
                throw new RuntimeException("Password can't be null or less then 8 characters long for DES encryption. Please pass the password as 2nd argument. Please refer: " + link);
            }
            this.ei = new LocalFileEncryption(this.pw);
        } else if (this.algo.equalsIgnoreCase(RSA)) {
            this.ei = new ZotKeyPair(this.bitLength, this);
        } else {
            throw new RuntimeException("the algorithm: " + this.algo + "does not exist or not supported by Zot Encrypto. Please refer docs at: " + link);
        }
    }

    public ZotPublicKey getPublicKey() {
        return this.keyPair.publicKey;
    }

    public static ZotPublicKey getPublicKey(String base64PublicKey) {
        Base64.Decoder decoder = Base64.getDecoder();
        JSONObject jsonObject = new JSONObject(new String(decoder.decode(base64PublicKey)));
        return new ZotPublicKey(jsonObject.getBigInteger("pe"), jsonObject.getBigInteger("on"));
    }

    public String getSterilizedPublicKey() {
        String returnPublicKeyB64 = this.keyPair.publicKey.sterilizePublicKey();
        if (returnPublicKeyB64 == null) {
            return "null";
        }
        return returnPublicKeyB64;
    }

    public String getPrivateKeyString() {
        String x = this.ei.getPrivateKeyString();
        if (x.equals("null")) {
            System.err.println("there are no keys ever used for DES local file encryption");
        }
        return x;
    }

    public String getPublicKeyString() {
        String x = this.ei.getPublicKeyString();
        if (x.equals("null")) {
            System.err.println("there are no keys ever used for DES local file encryption");
        }
        return x;
    }

    public String encrypt(String value, ZotPublicKey publicKey) {
        return this.ei.encrypt(value, publicKey);
    }

    public String encrypt(String value) {
        return this.ei.encrypt(value, null);
    }

    public String decrypt(String value) {
        return this.ei.decrypt(value);
    }
}

