/*
 * Decompiled with CFR 0.152.
 */
package dev.ssdd;

import dev.ssdd.Encrypto;
import dev.ssdd.EncryptoSpi;
import dev.ssdd.ZotPrivateKey;
import dev.ssdd.ZotPublicKey;
import java.security.SecureRandom;
import java.util.Base64;

public class ZotKeyPair
implements EncryptoSpi {
    private final ZotPrivateKey privateKey;
    ZotPublicKey publicKey;

    public ZotKeyPair(int bitLen, Encrypto encrypto) {
        this.privateKey = new ZotPrivateKey(bitLen, new SecureRandom().nextInt(9999), this, encrypto);
    }

    @Override
    public String encrypt(String val, ZotPublicKey publicKey) {
        if (publicKey == null) {
            throw new RuntimeException("ZotPublicKey can't be null for RSA encryption");
        }
        return publicKey.encrypt(val.getBytes());
    }

    @Override
    public String decrypt(String val) {
        return this.privateKey.decrypt(Base64.getDecoder().decode(val.getBytes()));
    }

    @Override
    public String getPublicKeyString() {
        return this.publicKey.toString();
    }

    @Override
    public String getPrivateKeyString() {
        return this.privateKey.toString();
    }
}

