/*
 * Decompiled with CFR 0.152.
 */
package dev.ssdd;

import dev.ssdd.BigIntPlayground;
import dev.ssdd.Encrypto;
import dev.ssdd.ZotKeyPair;
import dev.ssdd.ZotPublicKey;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;

public class ZotPrivateKey {
    private final BigInteger on;
    private final BigInteger d;

    public ZotPrivateKey(int bitLen, int nx, ZotKeyPair zotKeyPair, Encrypto encrypto) {
        SecureRandom secureRandom = new SecureRandom();
        BigInteger p = new BigInteger(bitLen, nx, secureRandom);
        BigInteger q = new BigInteger(bitLen, nx, secureRandom);
        BigInteger n = p.multiply(q);
        BigInteger pm1 = p.subtract(BigInteger.ONE);
        BigInteger qm1 = q.subtract(BigInteger.ONE);
        this.on = pm1.multiply(qm1);
        BigInteger e = new BigInteger(bitLen, nx, new SecureRandom());
        this.d = e.modInverse(this.on);
        try {
            this.assertEquals(e.multiply(this.d).mod(this.on));
            zotKeyPair.publicKey = new ZotPublicKey(e, n);
            encrypto.keyPair = zotKeyPair;
        }
        catch (AssertionError er) {
            ((Throwable)((Object)er)).printStackTrace();
        }
    }

    private void assertEquals(BigInteger mod) throws AssertionError {
        if (!BigInteger.ONE.equals(mod)) {
            throw new AssertionError((Object)"defect in generating keys.");
        }
    }

    public String decrypt(byte[] decode) {
        return new String(BigIntPlayground.writeBigInt(new BigInteger(new String(decode)).multiply(this.d).mod(this.on)), StandardCharsets.UTF_8);
    }

    public String toString() {
        return "Algo: RSA\nmodulus: " + this.on + "\nprivate exponent: " + this.d;
    }
}

