/*
 * Decompiled with CFR 0.152.
 */
package dev.surratt.ziptz4j;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public class ZipCode {
    private static final Properties zipCodeToTZ = new Properties();
    private final String value;

    public static ZipCode getZipCode(String value) {
        if (!ZipCode.isValid(value)) {
            throw new IllegalArgumentException("Invalid zip code [" + value + "]");
        }
        return new ZipCode(value);
    }

    private ZipCode(String value) {
        this.value = value;
    }

    public static boolean isValid(String zipCode) {
        if (zipCode == null) {
            return false;
        }
        return zipCode.matches("^\\d{5}(-?\\d{4})?$");
    }

    public String toString() {
        return this.value;
    }

    public String getCode() {
        return this.value.substring(0, 5);
    }

    public String getValue() {
        return this.value;
    }

    public boolean isExtended() {
        return this.value.length() != 5;
    }

    public String getTimeZone() {
        String timeZoneId = zipCodeToTZ.getProperty(this.getCode());
        if (timeZoneId == null) {
            timeZoneId = "UTC";
        }
        return timeZoneId;
    }

    static {
        ClassLoader classLoader = ZipCode.class.getClassLoader();
        String name = "tz.data";
        URL url = classLoader.getResource("tz.data");
        if (url == null) {
            throw new IllegalStateException("Could not locate file");
        }
        InputStream stream = classLoader.getResourceAsStream("tz.data");
        try {
            zipCodeToTZ.load(stream);
        }
        catch (IOException e) {
            e.printStackTrace();
            zipCodeToTZ.clear();
        }
    }
}

