/*
 * Decompiled with CFR 0.152.
 */
package dev.thatsnasu.ansi;

import dev.thatsnasu.ansi.Color;
import dev.thatsnasu.ansi.Color3b;
import dev.thatsnasu.ansi.Color4b;
import dev.thatsnasu.ansi.Color8b;
import dev.thatsnasu.ansi.Format;
import java.util.ArrayList;

public class Ansi {
    private Color3b color3b;
    private Color4b color4b;
    private Color8b color8b;
    private Color color;
    private ArrayList<Format> formats = new ArrayList();

    public Ansi() {
    }

    public Ansi(Color3b color3b, Format ... formats) {
        this.color3b = color3b;
        this.addFormats(formats);
    }

    public Ansi(Color4b color4b, Format ... formats) {
        this.color4b = color4b;
        this.addFormats(formats);
    }

    public Ansi(Color8b color8b, Format ... formats) {
        this.color8b = color8b;
        this.addFormats(formats);
    }

    public Ansi(Color color, Format ... formats) {
        this.color = color;
        this.addFormats(formats);
    }

    public static String getAnsiEscape(Color3b color3b, Format ... formats) {
        String escape = "\u001b[" + color3b.getColorCode();
        for (Format format : formats) {
            escape = escape + ";" + format.getFormatCode();
        }
        return escape + "m";
    }

    public static String getAnsiEscape(Color4b color4b, Format ... formats) {
        String escape = "\u001b[" + color4b.getColorCode();
        for (Format format : formats) {
            escape = escape + ";" + format.getFormatCode();
        }
        return escape + "m";
    }

    public static String getAnsiEscape(Color8b color8b, Format ... formats) {
        String escape = "\u001b[38;5;" + color8b.getColorCode();
        for (Format format : formats) {
            escape = escape + ";" + format.getFormatCode();
        }
        return escape + "m";
    }

    public static String getAnsiEscape(Color color, Format ... formats) {
        String escape = "\u001b[38;2;" + color.getColorCode();
        for (Format format : formats) {
            escape = escape + ";" + format.getFormatCode();
        }
        return escape + "m";
    }

    public static String getAnsiEscape(Format ... formats) {
        Object escape = "\u001b[";
        for (int i = 0; i < formats.length; ++i) {
            if (i > 0) {
                escape = (String)escape + ";";
            }
            escape = (String)escape + formats[i].getFormatCode();
        }
        return (String)escape + "m";
    }

    public String toString() {
        Object escape = "\u001b[";
        escape = (String)escape + (this.color3b != null ? this.color3b.getColorCode() : "");
        escape = (String)escape + (this.color4b != null ? this.color4b.getColorCode() : "");
        escape = (String)escape + (String)(this.color8b != null ? "38;5;" + this.color8b.getColorCode() : "");
        escape = (String)escape + (String)(this.color != null ? "38;2;" + this.color.getColorCode() : "");
        for (Format format : this.formats) {
            escape = (String)escape + ";" + format.getFormatCode();
        }
        return (String)escape + "m";
    }

    public void addFormats(Format ... formats) {
        for (Format format : formats) {
            if (this.formats.contains((Object)format)) continue;
            this.formats.add(format);
        }
    }

    public void removeFormats(Format ... formats) {
        for (Format format : formats) {
            if (!this.formats.contains((Object)format)) continue;
            this.formats.remove((Object)format);
        }
    }

    public void removeAllFormats() {
        this.formats = new ArrayList();
    }

    public Color3b getColor3b() {
        return this.color3b;
    }

    public Color4b getColor4b() {
        return this.color4b;
    }

    public Color8b getColor8b() {
        return this.color8b;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor3b(Color3b color3b) {
        this.color3b = color3b;
    }

    public void setColor4b(Color4b color4b) {
        this.color4b = color4b;
    }

    public void setColor8b(Color8b color8b) {
        this.color8b = color8b;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setFormats(Format ... formats) {
        this.formats = new ArrayList();
        for (Format format : formats) {
            this.formats.add(format);
        }
    }
}

