/*
 * Decompiled with CFR 0.152.
 */
package dev.thatsnasu.ansi;

import dev.thatsnasu.ansi.exceptions.MalformedHexadecimalException;
import dev.thatsnasu.ansi.exceptions.MalformedRGBException;

public class Color {
    private int red;
    private int green;
    private int blue;

    public Color(int red, int green, int blue) {
        if (red > 255 || red < 0) {
            throw new MalformedRGBException("Red can only range from 0-255, " + red + " given.");
        }
        if (green > 255 || green < 0) {
            throw new MalformedRGBException("Green can only range from 0-255, " + green + " given.");
        }
        if (blue > 255 || blue < 0) {
            throw new MalformedRGBException("Blue can only range from 0-255, " + blue + " given.");
        }
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public Color(String hexcode) {
        if (hexcode == null) {
            throw new IllegalArgumentException("Hexadecial value expected, null given");
        }
        if (hexcode.contains("#")) {
            hexcode = hexcode.replace("#", "");
        }
        if (!hexcode.matches("[0-9a-fA-F]+$") || hexcode.length() != 6 && hexcode.length() != 3) {
            throw new MalformedHexadecimalException("Hexadecimal values can only hold values from 0-9, a-f and A-F, with a length of 3 or 6 characters, \"" + hexcode + "\" given");
        }
        if (hexcode.length() == 3) {
            hexcode = hexcode.replaceAll(".", "$0$0");
        }
        long l = Long.parseLong(hexcode, 16);
        this.red = (int)(l / 65536L);
        this.green = (int)(l - (long)(65536 * this.red)) / 256;
        this.blue = (int)l - 65536 * this.red - 256 * this.green;
    }

    public String getColorCode() {
        return this.red + ";" + this.green + ";" + this.blue;
    }

    public String getHex() {
        return String.format("#%02x%02x%02x", this.red, this.green, this.blue);
    }

    public String getHex3() {
        String hex6 = this.getHex();
        return "#" + hex6.charAt(1) + hex6.charAt(3) + hex6.charAt(5);
    }

    public int getRed() {
        return this.red;
    }

    public String getRedAsHex() {
        return String.format("%02x", this.red);
    }

    public String getRedAsHex3() {
        return "" + this.getRedAsHex().charAt(0);
    }

    public int getGreen() {
        return this.green;
    }

    public String getGreenAsHex() {
        return String.format("%02x", this.green);
    }

    public String getGreenAsHex3() {
        return "" + this.getGreenAsHex().charAt(0);
    }

    public int getBlue() {
        return this.blue;
    }

    public String getBlueAsHex() {
        return String.format("%02x", this.blue);
    }

    public String getBlueAsHex3() {
        return "" + this.getBlueAsHex().charAt(0);
    }

    public int[] getRGB() {
        return new int[]{this.red, this.green, this.blue};
    }

    public String toString() {
        return "\u001b[38;2;" + this.getColorCode() + "m";
    }
}

