/*
 * Decompiled with CFR 0.152.
 */
package dev.theolm.txtlogwriter;

import co.touchlab.kermit.LogWriter;
import co.touchlab.kermit.Severity;
import dev.theolm.txtlogwriter.FileWriter;
import dev.theolm.txtlogwriter.LogWriterConfig;
import dev.theolm.txtlogwriter.MessageBuilder;
import dev.theolm.txtlogwriter.PlatformFileWriterKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J*\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ldev/theolm/txtlogwriter/TxtLogWriter;", "Lco/touchlab/kermit/LogWriter;", "config", "Ldev/theolm/txtlogwriter/LogWriterConfig;", "(Ldev/theolm/txtlogwriter/LogWriterConfig;)V", "fileWriter", "Ldev/theolm/txtlogwriter/FileWriter;", "messageBuilder", "Ldev/theolm/txtlogwriter/MessageBuilder;", "initFileWriter", "isLoggable", "", "tag", "", "severity", "Lco/touchlab/kermit/Severity;", "log", "", "message", "throwable", "", "file-logger_release"})
public final class TxtLogWriter
extends LogWriter {
    @NotNull
    private final LogWriterConfig config;
    @NotNull
    private final MessageBuilder messageBuilder;
    @Nullable
    private final FileWriter fileWriter;

    public TxtLogWriter(@NotNull LogWriterConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.messageBuilder = this.config.getMessageBuilder();
        this.fileWriter = this.initFileWriter();
    }

    public /* synthetic */ TxtLogWriter(LogWriterConfig logWriterConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            logWriterConfig = new LogWriterConfig(null, null, null, null, 15, null);
        }
        this(logWriterConfig);
    }

    public boolean isLoggable(@NotNull String tag, @NotNull Severity severity) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        return (Boolean)this.config.isLoggable().invoke((Object)tag, (Object)severity);
    }

    public void log(@NotNull Severity severity, @NotNull String message, @NotNull String tag, @Nullable Throwable throwable) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            if (!this.isLoggable(tag, severity)) {
                return;
            }
            FileWriter fileWriter = this.fileWriter;
            if (fileWriter == null) break block2;
            FileWriter writer = fileWriter;
            boolean bl = false;
            String logMessage = this.messageBuilder.buildLogMessage(severity, message, tag);
            writer.writeToFile$file_logger_release(logMessage);
            Throwable throwable2 = throwable;
            if (throwable2 != null) {
                Throwable it = throwable2;
                boolean bl2 = false;
                writer.writeToFile$file_logger_release(this.messageBuilder.buildThrowableMessage(it));
            }
        }
    }

    private final FileWriter initFileWriter() {
        String string = this.config.getFilePath();
        if (string == null && (string = PlatformFileWriterKt.getDefaultFileDir()) == null) {
            return null;
        }
        String fileDir = string;
        String string2 = this.config.getFileName();
        if (string2 == null) {
            string2 = PlatformFileWriterKt.getFileName();
        }
        String fileName = string2;
        return new FileWriter(fileDir, fileName);
    }

    public TxtLogWriter() {
        this(null, 1, null);
    }
}

