/*
 * Decompiled with CFR 0.152.
 */
package org.scalactic.anyvals;

import java.io.Serializable;
import java.util.Comparator;
import org.scalactic.Bad$;
import org.scalactic.Fail$;
import org.scalactic.Good$;
import org.scalactic.Or;
import org.scalactic.Pass$;
import org.scalactic.Validation;
import org.scalactic.anyvals.NonZeroDouble$;
import org.scalactic.anyvals.NonZeroFloat;
import org.scalactic.anyvals.NonZeroFloatMacro$;
import scala.Float$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichFloat;
import scala.util.Either;
import scala.util.Failure$;
import scala.util.Success$;
import scala.util.Try;

public final class NonZeroFloat$
implements Serializable {
    public static final NonZeroFloat$ MODULE$;
    private final float MaxValue;
    private final float MinValue;
    private final Ordering ordering;
    private final float PositiveInfinity;
    private final float NegativeInfinity;
    private final float MinPositiveValue;

    static {
        new NonZeroFloat$();
    }

    private NonZeroFloat$() {
        MODULE$ = this;
        this.MaxValue = this.ensuringValid(Float.MAX_VALUE);
        this.MinValue = this.ensuringValid(Float$.MODULE$.MinValue());
        this.ordering = new Comparator(){
            {
                PartialOrdering.$init$((PartialOrdering)this);
                Ordering.$init$((Ordering)this);
            }

            public int compare(float x, float y) {
                return new RichFloat(Predef$.MODULE$.floatWrapper(NonZeroFloat$.MODULE$.toFloat$extension(x))).compare((Object)BoxesRunTime.boxToFloat((float)NonZeroFloat$.MODULE$.widenToFloat(y)));
            }
        };
        this.PositiveInfinity = this.ensuringValid(Float.POSITIVE_INFINITY);
        this.NegativeInfinity = this.ensuringValid(Float.NEGATIVE_INFINITY);
        this.MinPositiveValue = this.ensuringValid(Float.MIN_VALUE);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(NonZeroFloat$.class);
    }

    public final float MaxValue() {
        return this.MaxValue;
    }

    public final float MinValue() {
        return this.MinValue;
    }

    public Option<NonZeroFloat> from(float value) {
        return NonZeroFloatMacro$.MODULE$.isValid(value) ? Some$.MODULE$.apply((Object)new NonZeroFloat(value)) : None$.MODULE$;
    }

    public float ensuringValid(float value) {
        if (!NonZeroFloatMacro$.MODULE$.isValid(value)) {
            throw new AssertionError((Object)(value + " was not a valid NonZeroFloat"));
        }
        return value;
    }

    public Try<NonZeroFloat> tryingValid(float value) {
        return NonZeroFloatMacro$.MODULE$.isValid(value) ? Success$.MODULE$.apply((Object)new NonZeroFloat(value)) : Failure$.MODULE$.apply((Throwable)((Object)new AssertionError((Object)(value + " was not a valid NonZeroFloat"))));
    }

    public <E> Validation<E> passOrElse(float value, Function1<Object, E> f) {
        return NonZeroFloatMacro$.MODULE$.isValid(value) ? Pass$.MODULE$ : Fail$.MODULE$.apply(f.apply((Object)BoxesRunTime.boxToFloat((float)value)));
    }

    public <B> Or<NonZeroFloat, B> goodOrElse(float value, Function1<Object, B> f) {
        return NonZeroFloatMacro$.MODULE$.isValid(value) ? Good$.MODULE$.apply(new NonZeroFloat(this.ensuringValid(value))) : Bad$.MODULE$.apply(f.apply((Object)BoxesRunTime.boxToFloat((float)value)));
    }

    public <L> Either<L, NonZeroFloat> rightOrElse(float value, Function1<Object, L> f) {
        return NonZeroFloatMacro$.MODULE$.isValid(value) ? scala.package$.MODULE$.Right().apply((Object)new NonZeroFloat(this.ensuringValid(value))) : scala.package$.MODULE$.Left().apply(f.apply((Object)BoxesRunTime.boxToFloat((float)value)));
    }

    public boolean isValid(float value) {
        return NonZeroFloatMacro$.MODULE$.isValid(value);
    }

    public float fromOrElse(float value, Function0 function0) {
        Object object;
        return NonZeroFloatMacro$.MODULE$.isValid(value) ? value : ((object = function0.apply()) == null ? BoxesRunTime.unboxToFloat(null) : ((NonZeroFloat)object).value());
    }

    public float widenToFloat(float pos) {
        return pos;
    }

    public double widenToDouble(float pos) {
        return Float$.MODULE$.float2double(pos);
    }

    public double widenToNonZeroDouble(float pos) {
        return NonZeroDouble$.MODULE$.ensuringValid(Float$.MODULE$.float2double(pos));
    }

    public Ordering<NonZeroFloat> ordering() {
        return this.ordering;
    }

    public final float PositiveInfinity() {
        return this.PositiveInfinity;
    }

    public final float NegativeInfinity() {
        return this.NegativeInfinity;
    }

    public final float MinPositiveValue() {
        return this.MinPositiveValue;
    }

    public final int hashCode$extension(float $this) {
        return ((Object)BoxesRunTime.boxToFloat((float)$this)).hashCode();
    }

    public final boolean equals$extension(float $this, Object x$0) {
        boolean bl;
        Object object = x$0;
        if (object instanceof NonZeroFloat) {
            float f;
            float f2 = f = object == null ? BoxesRunTime.unboxToFloat(null) : ((NonZeroFloat)object).value();
            bl = $this == f;
        } else {
            bl = false;
        }
        return bl;
    }

    public final String toString$extension(float $this) {
        return "NonZeroFloat(" + $this + "f)";
    }

    public final byte toByte$extension(float $this) {
        return (byte)$this;
    }

    public final short toShort$extension(float $this) {
        return (short)$this;
    }

    public final char toChar$extension(float $this) {
        return (char)$this;
    }

    public final int toInt$extension(float $this) {
        return (int)$this;
    }

    public final long toLong$extension(float $this) {
        return (long)$this;
    }

    public final float toFloat$extension(float $this) {
        return $this;
    }

    public final double toDouble$extension(float $this) {
        return $this;
    }

    public final float unary_$plus$extension(float $this) {
        return $this;
    }

    public final float unary_$minus$extension(float $this) {
        return this.ensuringValid(-$this);
    }

    public final String $plus$extension(float $this, String x) {
        return $this + x;
    }

    public final boolean $less$extension(float $this, byte x) {
        return $this < (float)x;
    }

    public final boolean $less$extension(float $this, short x) {
        return $this < (float)x;
    }

    public final boolean $less$extension(float $this, char x) {
        return $this < (float)x;
    }

    public final boolean $less$extension(float $this, int x) {
        return $this < (float)x;
    }

    public final boolean $less$extension(float $this, long x) {
        return $this < (float)x;
    }

    public final boolean $less$extension(float $this, float x) {
        return $this < x;
    }

    public final boolean $less$extension(float $this, double x) {
        return (double)$this < x;
    }

    public final boolean $less$eq$extension(float $this, byte x) {
        return $this <= (float)x;
    }

    public final boolean $less$eq$extension(float $this, short x) {
        return $this <= (float)x;
    }

    public final boolean $less$eq$extension(float $this, char x) {
        return $this <= (float)x;
    }

    public final boolean $less$eq$extension(float $this, int x) {
        return $this <= (float)x;
    }

    public final boolean $less$eq$extension(float $this, long x) {
        return $this <= (float)x;
    }

    public final boolean $less$eq$extension(float $this, float x) {
        return $this <= x;
    }

    public final boolean $less$eq$extension(float $this, double x) {
        return (double)$this <= x;
    }

    public final boolean $greater$extension(float $this, byte x) {
        return $this > (float)x;
    }

    public final boolean $greater$extension(float $this, short x) {
        return $this > (float)x;
    }

    public final boolean $greater$extension(float $this, char x) {
        return $this > (float)x;
    }

    public final boolean $greater$extension(float $this, int x) {
        return $this > (float)x;
    }

    public final boolean $greater$extension(float $this, long x) {
        return $this > (float)x;
    }

    public final boolean $greater$extension(float $this, float x) {
        return $this > x;
    }

    public final boolean $greater$extension(float $this, double x) {
        return (double)$this > x;
    }

    public final boolean $greater$eq$extension(float $this, byte x) {
        return $this >= (float)x;
    }

    public final boolean $greater$eq$extension(float $this, short x) {
        return $this >= (float)x;
    }

    public final boolean $greater$eq$extension(float $this, char x) {
        return $this >= (float)x;
    }

    public final boolean $greater$eq$extension(float $this, int x) {
        return $this >= (float)x;
    }

    public final boolean $greater$eq$extension(float $this, long x) {
        return $this >= (float)x;
    }

    public final boolean $greater$eq$extension(float $this, float x) {
        return $this >= x;
    }

    public final boolean $greater$eq$extension(float $this, double x) {
        return (double)$this >= x;
    }

    public final float $plus$extension(float $this, byte x) {
        return $this + (float)x;
    }

    public final float $plus$extension(float $this, short x) {
        return $this + (float)x;
    }

    public final float $plus$extension(float $this, char x) {
        return $this + (float)x;
    }

    public final float $plus$extension(float $this, int x) {
        return $this + (float)x;
    }

    public final float $plus$extension(float $this, long x) {
        return $this + (float)x;
    }

    public final float $plus$extension(float $this, float x) {
        return $this + x;
    }

    public final double $plus$extension(float $this, double x) {
        return (double)$this + x;
    }

    public final float $minus$extension(float $this, byte x) {
        return $this - (float)x;
    }

    public final float $minus$extension(float $this, short x) {
        return $this - (float)x;
    }

    public final float $minus$extension(float $this, char x) {
        return $this - (float)x;
    }

    public final float $minus$extension(float $this, int x) {
        return $this - (float)x;
    }

    public final float $minus$extension(float $this, long x) {
        return $this - (float)x;
    }

    public final float $minus$extension(float $this, float x) {
        return $this - x;
    }

    public final double $minus$extension(float $this, double x) {
        return (double)$this - x;
    }

    public final float $times$extension(float $this, byte x) {
        return $this * (float)x;
    }

    public final float $times$extension(float $this, short x) {
        return $this * (float)x;
    }

    public final float $times$extension(float $this, char x) {
        return $this * (float)x;
    }

    public final float $times$extension(float $this, int x) {
        return $this * (float)x;
    }

    public final float $times$extension(float $this, long x) {
        return $this * (float)x;
    }

    public final float $times$extension(float $this, float x) {
        return $this * x;
    }

    public final double $times$extension(float $this, double x) {
        return (double)$this * x;
    }

    public final float $div$extension(float $this, byte x) {
        return $this / (float)x;
    }

    public final float $div$extension(float $this, short x) {
        return $this / (float)x;
    }

    public final float $div$extension(float $this, char x) {
        return $this / (float)x;
    }

    public final float $div$extension(float $this, int x) {
        return $this / (float)x;
    }

    public final float $div$extension(float $this, long x) {
        return $this / (float)x;
    }

    public final float $div$extension(float $this, float x) {
        return $this / x;
    }

    public final double $div$extension(float $this, double x) {
        return (double)$this / x;
    }

    public final float $percent$extension(float $this, byte x) {
        return $this % (float)x;
    }

    public final float $percent$extension(float $this, short x) {
        return $this % (float)x;
    }

    public final float $percent$extension(float $this, char x) {
        return $this % (float)x;
    }

    public final float $percent$extension(float $this, int x) {
        return $this % (float)x;
    }

    public final float $percent$extension(float $this, long x) {
        return $this % (float)x;
    }

    public final float $percent$extension(float $this, float x) {
        return $this % x;
    }

    public final double $percent$extension(float $this, double x) {
        return (double)$this % x;
    }

    public final float max$extension(float $this, float that) {
        return package$.MODULE$.max($this, that) == $this ? $this : that;
    }

    public final float min$extension(float $this, float that) {
        return package$.MODULE$.min($this, that) == $this ? $this : that;
    }

    public final boolean isWhole$extension(float $this) {
        long longValue = (long)$this;
        return (float)longValue == $this || longValue == Long.MAX_VALUE && $this < Float.POSITIVE_INFINITY || longValue == Long.MIN_VALUE && $this > Float.NEGATIVE_INFINITY;
    }

    public final float toRadians$extension(float $this) {
        return (float)package$.MODULE$.toRadians((double)$this);
    }

    public final float toDegrees$extension(float $this) {
        return (float)package$.MODULE$.toDegrees((double)$this);
    }

    public final float ensuringValid$extension(float $this, Function1<Object, Object> f) {
        float candidateResult = BoxesRunTime.unboxToFloat((Object)f.apply((Object)BoxesRunTime.boxToFloat((float)$this)));
        if (!NonZeroFloatMacro$.MODULE$.isValid(candidateResult)) {
            throw new AssertionError((Object)(candidateResult + ", the result of applying the passed function to " + $this + ", was not a valid NonZeroFloat"));
        }
        return candidateResult;
    }

    public final boolean isPosInfinity$extension(float $this) {
        return Float.POSITIVE_INFINITY == $this;
    }

    public final boolean isNegInfinity$extension(float $this) {
        return Float.NEGATIVE_INFINITY == $this;
    }

    public final boolean isInfinite$extension(float $this) {
        return Predef$.MODULE$.float2Float($this).isInfinite();
    }

    public final boolean isFinite$extension(float $this) {
        return !Predef$.MODULE$.float2Float($this).isInfinite();
    }
}

