package dev.tunnicliff.logging.internal.database;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import dev.tunnicliff.logging.model.LogLevel;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class LogDao_Impl implements LogDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<LogEntity> __insertionAdapterOfLogEntity;

  private final Converters __converters = new Converters();

  private final EntityDeletionOrUpdateAdapter<LogEntity> __updateAdapterOfLogEntity;

  private final SharedSQLiteStatement __preparedStmtOfDeleteLogsOlderThan;

  public LogDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfLogEntity = new EntityInsertionAdapter<LogEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `LogEntity` (`id`,`level`,`message`,`tag`,`timestampCreated`,`timestampUpdated`,`throwable`,`uploaded`) VALUES (?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final LogEntity entity) {
        final String _tmp = __converters.fromUUID(entity.getId());
        statement.bindString(1, _tmp);
        final String _tmp_1 = __converters.fromLogLevel(entity.getLevel());
        statement.bindString(2, _tmp_1);
        statement.bindString(3, entity.getMessage());
        statement.bindString(4, entity.getTag());
        final long _tmp_2 = __converters.fromInstant(entity.getTimestampCreated());
        statement.bindLong(5, _tmp_2);
        final long _tmp_3 = __converters.fromInstant(entity.getTimestampUpdated());
        statement.bindLong(6, _tmp_3);
        final String _tmp_4;
        if (entity.getThrowable() == null) {
          _tmp_4 = null;
        } else {
          _tmp_4 = __converters.fromThrowable(entity.getThrowable());
        }
        if (_tmp_4 == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, _tmp_4);
        }
        final int _tmp_5 = entity.getUploaded() ? 1 : 0;
        statement.bindLong(8, _tmp_5);
      }
    };
    this.__updateAdapterOfLogEntity = new EntityDeletionOrUpdateAdapter<LogEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `LogEntity` SET `id` = ?,`level` = ?,`message` = ?,`tag` = ?,`timestampCreated` = ?,`timestampUpdated` = ?,`throwable` = ?,`uploaded` = ? WHERE `id` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final LogEntity entity) {
        final String _tmp = __converters.fromUUID(entity.getId());
        statement.bindString(1, _tmp);
        final String _tmp_1 = __converters.fromLogLevel(entity.getLevel());
        statement.bindString(2, _tmp_1);
        statement.bindString(3, entity.getMessage());
        statement.bindString(4, entity.getTag());
        final long _tmp_2 = __converters.fromInstant(entity.getTimestampCreated());
        statement.bindLong(5, _tmp_2);
        final long _tmp_3 = __converters.fromInstant(entity.getTimestampUpdated());
        statement.bindLong(6, _tmp_3);
        final String _tmp_4;
        if (entity.getThrowable() == null) {
          _tmp_4 = null;
        } else {
          _tmp_4 = __converters.fromThrowable(entity.getThrowable());
        }
        if (_tmp_4 == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, _tmp_4);
        }
        final int _tmp_5 = entity.getUploaded() ? 1 : 0;
        statement.bindLong(8, _tmp_5);
        final String _tmp_6 = __converters.fromUUID(entity.getId());
        statement.bindString(9, _tmp_6);
      }
    };
    this.__preparedStmtOfDeleteLogsOlderThan = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE from LogEntity where timestampCreated<=?";
        return _query;
      }
    };
  }

  @Override
  public Object insert(final LogEntity logEntity, final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfLogEntity.insert(logEntity);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object update(final LogEntity[] logEntity,
      final Continuation<? super Integer> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfLogEntity.handleMultiple(logEntity);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object deleteLogsOlderThan(final Instant timestamp,
      final Continuation<? super Integer> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteLogsOlderThan.acquire();
        int _argIndex = 1;
        final long _tmp = __converters.fromInstant(timestamp);
        _stmt.bindLong(_argIndex, _tmp);
        try {
          __db.beginTransaction();
          try {
            final Integer _result = _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDeleteLogsOlderThan.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object getLog(final UUID id, final Continuation<? super LogEntity> $completion) {
    final String _sql = "SELECT * FROM LogEntity WHERE id=?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __converters.fromUUID(id);
    _statement.bindString(_argIndex, _tmp);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<LogEntity>() {
      @Override
      @NonNull
      public LogEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
          final int _cursorIndexOfLevel = CursorUtil.getColumnIndexOrThrow(_cursor, "level");
          final int _cursorIndexOfMessage = CursorUtil.getColumnIndexOrThrow(_cursor, "message");
          final int _cursorIndexOfTag = CursorUtil.getColumnIndexOrThrow(_cursor, "tag");
          final int _cursorIndexOfTimestampCreated = CursorUtil.getColumnIndexOrThrow(_cursor, "timestampCreated");
          final int _cursorIndexOfTimestampUpdated = CursorUtil.getColumnIndexOrThrow(_cursor, "timestampUpdated");
          final int _cursorIndexOfThrowable = CursorUtil.getColumnIndexOrThrow(_cursor, "throwable");
          final int _cursorIndexOfUploaded = CursorUtil.getColumnIndexOrThrow(_cursor, "uploaded");
          final LogEntity _result;
          if (_cursor.moveToFirst()) {
            final UUID _tmpId;
            final String _tmp_1;
            _tmp_1 = _cursor.getString(_cursorIndexOfId);
            _tmpId = __converters.toUUID(_tmp_1);
            final LogLevel _tmpLevel;
            final String _tmp_2;
            _tmp_2 = _cursor.getString(_cursorIndexOfLevel);
            _tmpLevel = __converters.toLogLevel(_tmp_2);
            final String _tmpMessage;
            _tmpMessage = _cursor.getString(_cursorIndexOfMessage);
            final String _tmpTag;
            _tmpTag = _cursor.getString(_cursorIndexOfTag);
            final Instant _tmpTimestampCreated;
            final long _tmp_3;
            _tmp_3 = _cursor.getLong(_cursorIndexOfTimestampCreated);
            _tmpTimestampCreated = __converters.toInstant(_tmp_3);
            final Instant _tmpTimestampUpdated;
            final long _tmp_4;
            _tmp_4 = _cursor.getLong(_cursorIndexOfTimestampUpdated);
            _tmpTimestampUpdated = __converters.toInstant(_tmp_4);
            final LogEntity.Throwable _tmpThrowable;
            final String _tmp_5;
            if (_cursor.isNull(_cursorIndexOfThrowable)) {
              _tmp_5 = null;
            } else {
              _tmp_5 = _cursor.getString(_cursorIndexOfThrowable);
            }
            if (_tmp_5 == null) {
              _tmpThrowable = null;
            } else {
              _tmpThrowable = __converters.toThrowable(_tmp_5);
            }
            final boolean _tmpUploaded;
            final int _tmp_6;
            _tmp_6 = _cursor.getInt(_cursorIndexOfUploaded);
            _tmpUploaded = _tmp_6 != 0;
            _result = new LogEntity(_tmpId,_tmpLevel,_tmpMessage,_tmpTag,_tmpTimestampCreated,_tmpTimestampUpdated,_tmpThrowable,_tmpUploaded);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public PagingSource<Integer, LogEntity> getLogs() {
    final String _sql = "SELECT * FROM LogEntity ORDER BY timestampCreated DESC, id";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    return new LimitOffsetPagingSource<LogEntity>(_statement, __db, "LogEntity") {
      @Override
      @NonNull
      protected List<LogEntity> convertRows(@NonNull final Cursor cursor) {
        final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(cursor, "id");
        final int _cursorIndexOfLevel = CursorUtil.getColumnIndexOrThrow(cursor, "level");
        final int _cursorIndexOfMessage = CursorUtil.getColumnIndexOrThrow(cursor, "message");
        final int _cursorIndexOfTag = CursorUtil.getColumnIndexOrThrow(cursor, "tag");
        final int _cursorIndexOfTimestampCreated = CursorUtil.getColumnIndexOrThrow(cursor, "timestampCreated");
        final int _cursorIndexOfTimestampUpdated = CursorUtil.getColumnIndexOrThrow(cursor, "timestampUpdated");
        final int _cursorIndexOfThrowable = CursorUtil.getColumnIndexOrThrow(cursor, "throwable");
        final int _cursorIndexOfUploaded = CursorUtil.getColumnIndexOrThrow(cursor, "uploaded");
        final List<LogEntity> _result = new ArrayList<LogEntity>(cursor.getCount());
        while (cursor.moveToNext()) {
          final LogEntity _item;
          final UUID _tmpId;
          final String _tmp;
          _tmp = cursor.getString(_cursorIndexOfId);
          _tmpId = __converters.toUUID(_tmp);
          final LogLevel _tmpLevel;
          final String _tmp_1;
          _tmp_1 = cursor.getString(_cursorIndexOfLevel);
          _tmpLevel = __converters.toLogLevel(_tmp_1);
          final String _tmpMessage;
          _tmpMessage = cursor.getString(_cursorIndexOfMessage);
          final String _tmpTag;
          _tmpTag = cursor.getString(_cursorIndexOfTag);
          final Instant _tmpTimestampCreated;
          final long _tmp_2;
          _tmp_2 = cursor.getLong(_cursorIndexOfTimestampCreated);
          _tmpTimestampCreated = __converters.toInstant(_tmp_2);
          final Instant _tmpTimestampUpdated;
          final long _tmp_3;
          _tmp_3 = cursor.getLong(_cursorIndexOfTimestampUpdated);
          _tmpTimestampUpdated = __converters.toInstant(_tmp_3);
          final LogEntity.Throwable _tmpThrowable;
          final String _tmp_4;
          if (cursor.isNull(_cursorIndexOfThrowable)) {
            _tmp_4 = null;
          } else {
            _tmp_4 = cursor.getString(_cursorIndexOfThrowable);
          }
          if (_tmp_4 == null) {
            _tmpThrowable = null;
          } else {
            _tmpThrowable = __converters.toThrowable(_tmp_4);
          }
          final boolean _tmpUploaded;
          final int _tmp_5;
          _tmp_5 = cursor.getInt(_cursorIndexOfUploaded);
          _tmpUploaded = _tmp_5 != 0;
          _item = new LogEntity(_tmpId,_tmpLevel,_tmpMessage,_tmpTag,_tmpTimestampCreated,_tmpTimestampUpdated,_tmpThrowable,_tmpUploaded);
          _result.add(_item);
        }
        return _result;
      }
    };
  }

  @Override
  public Object getDatabaseSizeInfo(
      final Continuation<? super List<SystemDatabaseSizeInfo>> $completion) {
    final String _sql = "SELECT s.*, c.* FROM pragma_page_size as s JOIN pragma_page_count as c";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<SystemDatabaseSizeInfo>>() {
      @Override
      @NonNull
      public List<SystemDatabaseSizeInfo> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPageSizeBytes = CursorUtil.getColumnIndexOrThrow(_cursor, "page_size");
          final int _cursorIndexOfPageCount = CursorUtil.getColumnIndexOrThrow(_cursor, "page_count");
          final List<SystemDatabaseSizeInfo> _result = new ArrayList<SystemDatabaseSizeInfo>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final SystemDatabaseSizeInfo _item;
            final Integer _tmpPageSizeBytes;
            if (_cursor.isNull(_cursorIndexOfPageSizeBytes)) {
              _tmpPageSizeBytes = null;
            } else {
              _tmpPageSizeBytes = _cursor.getInt(_cursorIndexOfPageSizeBytes);
            }
            final Integer _tmpPageCount;
            if (_cursor.isNull(_cursorIndexOfPageCount)) {
              _tmpPageCount = null;
            } else {
              _tmpPageCount = _cursor.getInt(_cursorIndexOfPageCount);
            }
            _item = new SystemDatabaseSizeInfo(_tmpPageSizeBytes,_tmpPageCount);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
