/*
 * Decompiled with CFR 0.152.
 */
package dev.tunnicliff.logging.internal.database;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import dev.tunnicliff.logging.internal.database.LogDao;
import dev.tunnicliff.logging.internal.database.LogDao_Impl;
import dev.tunnicliff.logging.internal.database.LoggingDatabase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class LoggingDatabase_Impl
extends LoggingDatabase {
    private volatile LogDao _logDao;

    @NonNull
    protected SupportSQLiteOpenHelper createOpenHelper(@NonNull DatabaseConfiguration config) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(config, new RoomOpenHelper.Delegate(1){

            public void createAllTables(@NonNull SupportSQLiteDatabase db) {
                db.execSQL("CREATE TABLE IF NOT EXISTS `LogEntity` (`id` TEXT NOT NULL, `level` TEXT NOT NULL, `message` TEXT NOT NULL, `tag` TEXT NOT NULL, `timestampCreated` INTEGER NOT NULL, `timestampUpdated` INTEGER NOT NULL, `throwable` TEXT, `uploaded` INTEGER NOT NULL, PRIMARY KEY(`id`))");
                db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, 'cda8bb5f8e36b720c68272a29e4198d0')");
            }

            public void dropAllTables(@NonNull SupportSQLiteDatabase db) {
                db.execSQL("DROP TABLE IF EXISTS `LogEntity`");
                List _callbacks = LoggingDatabase_Impl.this.mCallbacks;
                if (_callbacks != null) {
                    for (RoomDatabase.Callback _callback : _callbacks) {
                        _callback.onDestructiveMigration(db);
                    }
                }
            }

            public void onCreate(@NonNull SupportSQLiteDatabase db) {
                List _callbacks = LoggingDatabase_Impl.this.mCallbacks;
                if (_callbacks != null) {
                    for (RoomDatabase.Callback _callback : _callbacks) {
                        _callback.onCreate(db);
                    }
                }
            }

            public void onOpen(@NonNull SupportSQLiteDatabase db) {
                LoggingDatabase_Impl.this.mDatabase = db;
                LoggingDatabase_Impl.this.internalInitInvalidationTracker(db);
                List _callbacks = LoggingDatabase_Impl.this.mCallbacks;
                if (_callbacks != null) {
                    for (RoomDatabase.Callback _callback : _callbacks) {
                        _callback.onOpen(db);
                    }
                }
            }

            public void onPreMigrate(@NonNull SupportSQLiteDatabase db) {
                DBUtil.dropFtsSyncTriggers((SupportSQLiteDatabase)db);
            }

            public void onPostMigrate(@NonNull SupportSQLiteDatabase db) {
            }

            @NonNull
            public RoomOpenHelper.ValidationResult onValidateSchema(@NonNull SupportSQLiteDatabase db) {
                HashMap<String, TableInfo.Column> _columnsLogEntity = new HashMap<String, TableInfo.Column>(8);
                _columnsLogEntity.put("id", new TableInfo.Column("id", "TEXT", true, 1, null, 1));
                _columnsLogEntity.put("level", new TableInfo.Column("level", "TEXT", true, 0, null, 1));
                _columnsLogEntity.put("message", new TableInfo.Column("message", "TEXT", true, 0, null, 1));
                _columnsLogEntity.put("tag", new TableInfo.Column("tag", "TEXT", true, 0, null, 1));
                _columnsLogEntity.put("timestampCreated", new TableInfo.Column("timestampCreated", "INTEGER", true, 0, null, 1));
                _columnsLogEntity.put("timestampUpdated", new TableInfo.Column("timestampUpdated", "INTEGER", true, 0, null, 1));
                _columnsLogEntity.put("throwable", new TableInfo.Column("throwable", "TEXT", false, 0, null, 1));
                _columnsLogEntity.put("uploaded", new TableInfo.Column("uploaded", "INTEGER", true, 0, null, 1));
                HashSet _foreignKeysLogEntity = new HashSet(0);
                HashSet _indicesLogEntity = new HashSet(0);
                TableInfo _infoLogEntity = new TableInfo("LogEntity", _columnsLogEntity, _foreignKeysLogEntity, _indicesLogEntity);
                TableInfo _existingLogEntity = TableInfo.read((SupportSQLiteDatabase)db, (String)"LogEntity");
                if (!_infoLogEntity.equals((Object)_existingLogEntity)) {
                    return new RoomOpenHelper.ValidationResult(false, "LogEntity(dev.tunnicliff.logging.internal.database.LogEntity).\n Expected:\n" + _infoLogEntity + "\n Found:\n" + _existingLogEntity);
                }
                return new RoomOpenHelper.ValidationResult(true, null);
            }
        }, "cda8bb5f8e36b720c68272a29e4198d0", "946791ebd8b7db5a1e88a98ae49d750b");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)config.context).name(config.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = config.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    @NonNull
    protected InvalidationTracker createInvalidationTracker() {
        HashMap _shadowTablesMap = new HashMap(0);
        HashMap _viewTables = new HashMap(0);
        return new InvalidationTracker((RoomDatabase)this, _shadowTablesMap, _viewTables, new String[]{"LogEntity"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        try {
            super.beginTransaction();
            _db.execSQL("DELETE FROM `LogEntity`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    @NonNull
    protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
        HashMap _typeConvertersMap = new HashMap();
        _typeConvertersMap.put(LogDao.class, LogDao_Impl.getRequiredConverters());
        return _typeConvertersMap;
    }

    @NonNull
    public Set<Class<? extends AutoMigrationSpec>> getRequiredAutoMigrationSpecs() {
        HashSet<Class<? extends AutoMigrationSpec>> _autoMigrationSpecsSet = new HashSet<Class<? extends AutoMigrationSpec>>();
        return _autoMigrationSpecsSet;
    }

    @NonNull
    public List<Migration> getAutoMigrations(@NonNull Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> autoMigrationSpecs) {
        ArrayList<Migration> _autoMigrations = new ArrayList<Migration>();
        return _autoMigrations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogDao logDao() {
        if (this._logDao != null) {
            return this._logDao;
        }
        LoggingDatabase_Impl loggingDatabase_Impl = this;
        synchronized (loggingDatabase_Impl) {
            if (this._logDao == null) {
                this._logDao = new LogDao_Impl(this);
            }
            return this._logDao;
        }
    }
}

