/*
 * Decompiled with CFR 0.152.
 */
package dev.tunnicliff.logging.internal.database;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.room.TypeConverter;
import dev.tunnicliff.logging.internal.database.LogEntity;
import dev.tunnicliff.logging.model.LogLevel;
import java.time.Instant;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\bH\u0007J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\bH\u0007J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\bH\u0007\u00a8\u0006\u0012"}, d2={"Ldev/tunnicliff/logging/internal/database/Converters;", "", "()V", "fromInstant", "", "value", "Ljava/time/Instant;", "fromLogLevel", "", "Ldev/tunnicliff/logging/model/LogLevel;", "fromThrowable", "Ldev/tunnicliff/logging/internal/database/LogEntity$Throwable;", "fromUUID", "Ljava/util/UUID;", "toInstant", "toLogLevel", "toThrowable", "toUUID", "lib_release"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nConverters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Converters.kt\ndev/tunnicliff/logging/internal/database/Converters\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,52:1\n113#2:53\n96#3:54\n*S KotlinDebug\n*F\n+ 1 Converters.kt\ndev/tunnicliff/logging/internal/database/Converters\n*L\n35#1:53\n39#1:54\n*E\n"})
public final class Converters {
    public static final int $stable;

    @TypeConverter
    public final long fromInstant(@NotNull Instant value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return value.toEpochMilli();
    }

    @TypeConverter
    @NotNull
    public final Instant toInstant(long value) {
        Instant instant = Instant.ofEpochMilli(value);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochMilli(...)");
        return instant;
    }

    @TypeConverter
    @NotNull
    public final String fromLogLevel(@NotNull LogLevel value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        return value.name();
    }

    @TypeConverter
    @NotNull
    public final LogLevel toLogLevel(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return LogLevel.valueOf(value);
    }

    @TypeConverter
    @NotNull
    public final String fromThrowable(@NotNull LogEntity.Throwable value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        StringFormat $this$encodeToString$iv = (StringFormat)Json.Default;
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        return $this$encodeToString$iv.encodeToString((SerializationStrategy)LogEntity.Throwable.Companion.serializer(), (Object)value);
    }

    @TypeConverter
    @NotNull
    public final LogEntity.Throwable toThrowable(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Json this_$iv = (Json)Json.Default;
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        return (LogEntity.Throwable)this_$iv.decodeFromString((DeserializationStrategy)LogEntity.Throwable.Companion.serializer(), value);
    }

    @TypeConverter
    @NotNull
    public final String fromUUID(@NotNull UUID value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = value.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @TypeConverter
    @NotNull
    public final UUID toUUID(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        UUID uUID = UUID.fromString(value);
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
        return uUID;
    }
}

