/*
 * Decompiled with CFR 0.152.
 */
package dev.tunnicliff.logging.internal.database;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import dev.tunnicliff.logging.internal.database.Converters;
import dev.tunnicliff.logging.internal.database.LogDao;
import dev.tunnicliff.logging.internal.database.LogEntity;
import dev.tunnicliff.logging.internal.database.SystemDatabaseSizeInfo;
import dev.tunnicliff.logging.model.LogLevel;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class LogDao_Impl
implements LogDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<LogEntity> __insertionAdapterOfLogEntity;
    private final Converters __converters = new Converters();
    private final EntityDeletionOrUpdateAdapter<LogEntity> __updateAdapterOfLogEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteLogsOlderThan;

    public LogDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfLogEntity = new EntityInsertionAdapter<LogEntity>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `LogEntity` (`id`,`level`,`message`,`tag`,`timestampCreated`,`timestampUpdated`,`throwable`,`uploaded`) VALUES (?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull LogEntity entity) {
                String _tmp = LogDao_Impl.this.__converters.fromUUID(entity.getId());
                statement.bindString(1, _tmp);
                String _tmp_1 = LogDao_Impl.this.__converters.fromLogLevel(entity.getLevel());
                statement.bindString(2, _tmp_1);
                statement.bindString(3, entity.getMessage());
                statement.bindString(4, entity.getTag());
                long _tmp_2 = LogDao_Impl.this.__converters.fromInstant(entity.getTimestampCreated());
                statement.bindLong(5, _tmp_2);
                long _tmp_3 = LogDao_Impl.this.__converters.fromInstant(entity.getTimestampUpdated());
                statement.bindLong(6, _tmp_3);
                String _tmp_4 = entity.getThrowable() == null ? null : LogDao_Impl.this.__converters.fromThrowable(entity.getThrowable());
                if (_tmp_4 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindString(7, _tmp_4);
                }
                int _tmp_5 = entity.getUploaded() ? 1 : 0;
                statement.bindLong(8, (long)_tmp_5);
            }
        };
        this.__updateAdapterOfLogEntity = new EntityDeletionOrUpdateAdapter<LogEntity>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `LogEntity` SET `id` = ?,`level` = ?,`message` = ?,`tag` = ?,`timestampCreated` = ?,`timestampUpdated` = ?,`throwable` = ?,`uploaded` = ? WHERE `id` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull LogEntity entity) {
                String _tmp = LogDao_Impl.this.__converters.fromUUID(entity.getId());
                statement.bindString(1, _tmp);
                String _tmp_1 = LogDao_Impl.this.__converters.fromLogLevel(entity.getLevel());
                statement.bindString(2, _tmp_1);
                statement.bindString(3, entity.getMessage());
                statement.bindString(4, entity.getTag());
                long _tmp_2 = LogDao_Impl.this.__converters.fromInstant(entity.getTimestampCreated());
                statement.bindLong(5, _tmp_2);
                long _tmp_3 = LogDao_Impl.this.__converters.fromInstant(entity.getTimestampUpdated());
                statement.bindLong(6, _tmp_3);
                String _tmp_4 = entity.getThrowable() == null ? null : LogDao_Impl.this.__converters.fromThrowable(entity.getThrowable());
                if (_tmp_4 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindString(7, _tmp_4);
                }
                int _tmp_5 = entity.getUploaded() ? 1 : 0;
                statement.bindLong(8, (long)_tmp_5);
                String _tmp_6 = LogDao_Impl.this.__converters.fromUUID(entity.getId());
                statement.bindString(9, _tmp_6);
            }
        };
        this.__preparedStmtOfDeleteLogsOlderThan = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "DELETE from LogEntity where timestampCreated<=?";
                return "DELETE from LogEntity where timestampCreated<=?";
            }
        };
    }

    @Override
    public Object insert(final LogEntity logEntity, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                LogDao_Impl.this.__db.beginTransaction();
                try {
                    LogDao_Impl.this.__insertionAdapterOfLogEntity.insert((Object)logEntity);
                    LogDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    LogDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object update(final LogEntity[] logEntity, Continuation<? super Integer> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            @NonNull
            public Integer call() throws Exception {
                int _total = 0;
                LogDao_Impl.this.__db.beginTransaction();
                try {
                    LogDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += LogDao_Impl.this.__updateAdapterOfLogEntity.handleMultiple((Object[])logEntity);
                    return n;
                }
                finally {
                    LogDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object deleteLogsOlderThan(final Instant timestamp, Continuation<? super Integer> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Integer call() throws Exception {
                SupportSQLiteStatement _stmt = LogDao_Impl.this.__preparedStmtOfDeleteLogsOlderThan.acquire();
                int _argIndex = 1;
                long _tmp = LogDao_Impl.this.__converters.fromInstant(timestamp);
                _stmt.bindLong(_argIndex, _tmp);
                try {
                    Integer n;
                    LogDao_Impl.this.__db.beginTransaction();
                    try {
                        Integer _result = _stmt.executeUpdateDelete();
                        LogDao_Impl.this.__db.setTransactionSuccessful();
                        n = _result;
                    }
                    catch (Throwable throwable) {
                        LogDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    LogDao_Impl.this.__db.endTransaction();
                    return n;
                }
                finally {
                    LogDao_Impl.this.__preparedStmtOfDeleteLogsOlderThan.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object getLog(UUID id, Continuation<? super LogEntity> $completion) {
        String _sql = "SELECT * FROM LogEntity WHERE id=?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM LogEntity WHERE id=?", (int)1);
        int _argIndex = 1;
        String _tmp = this.__converters.fromUUID(id);
        _statement.bindString(_argIndex, _tmp);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<LogEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public LogEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)LogDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    LogEntity _result;
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfLevel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"level");
                    int _cursorIndexOfMessage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"message");
                    int _cursorIndexOfTag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tag");
                    int _cursorIndexOfTimestampCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestampCreated");
                    int _cursorIndexOfTimestampUpdated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestampUpdated");
                    int _cursorIndexOfThrowable = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"throwable");
                    int _cursorIndexOfUploaded = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uploaded");
                    if (_cursor.moveToFirst()) {
                        String _tmp_1 = _cursor.getString(_cursorIndexOfId);
                        UUID _tmpId = LogDao_Impl.this.__converters.toUUID(_tmp_1);
                        String _tmp_2 = _cursor.getString(_cursorIndexOfLevel);
                        LogLevel _tmpLevel = LogDao_Impl.this.__converters.toLogLevel(_tmp_2);
                        String _tmpMessage = _cursor.getString(_cursorIndexOfMessage);
                        String _tmpTag = _cursor.getString(_cursorIndexOfTag);
                        long _tmp_3 = _cursor.getLong(_cursorIndexOfTimestampCreated);
                        Instant _tmpTimestampCreated = LogDao_Impl.this.__converters.toInstant(_tmp_3);
                        long _tmp_4 = _cursor.getLong(_cursorIndexOfTimestampUpdated);
                        Instant _tmpTimestampUpdated = LogDao_Impl.this.__converters.toInstant(_tmp_4);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfThrowable) ? null : _cursor.getString(_cursorIndexOfThrowable);
                        LogEntity.Throwable _tmpThrowable = _tmp_5 == null ? null : LogDao_Impl.this.__converters.toThrowable(_tmp_5);
                        int _tmp_6 = _cursor.getInt(_cursorIndexOfUploaded);
                        boolean _tmpUploaded = _tmp_6 != 0;
                        _result = new LogEntity(_tmpId, _tmpLevel, _tmpMessage, _tmpTag, _tmpTimestampCreated, _tmpTimestampUpdated, _tmpThrowable, _tmpUploaded);
                    } else {
                        _result = null;
                    }
                    LogEntity logEntity = _result;
                    return logEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public PagingSource<Integer, LogEntity> getLogs() {
        String _sql = "SELECT * FROM LogEntity ORDER BY timestampCreated DESC, id";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM LogEntity ORDER BY timestampCreated DESC, id", (int)0);
        return new LimitOffsetPagingSource<LogEntity>(_statement, this.__db, new String[]{"LogEntity"}){

            @NonNull
            protected List<LogEntity> convertRows(@NonNull Cursor cursor) {
                int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"id");
                int _cursorIndexOfLevel = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"level");
                int _cursorIndexOfMessage = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"message");
                int _cursorIndexOfTag = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"tag");
                int _cursorIndexOfTimestampCreated = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"timestampCreated");
                int _cursorIndexOfTimestampUpdated = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"timestampUpdated");
                int _cursorIndexOfThrowable = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"throwable");
                int _cursorIndexOfUploaded = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"uploaded");
                ArrayList<LogEntity> _result = new ArrayList<LogEntity>(cursor.getCount());
                while (cursor.moveToNext()) {
                    String _tmp = cursor.getString(_cursorIndexOfId);
                    UUID _tmpId = LogDao_Impl.this.__converters.toUUID(_tmp);
                    String _tmp_1 = cursor.getString(_cursorIndexOfLevel);
                    LogLevel _tmpLevel = LogDao_Impl.this.__converters.toLogLevel(_tmp_1);
                    String _tmpMessage = cursor.getString(_cursorIndexOfMessage);
                    String _tmpTag = cursor.getString(_cursorIndexOfTag);
                    long _tmp_2 = cursor.getLong(_cursorIndexOfTimestampCreated);
                    Instant _tmpTimestampCreated = LogDao_Impl.this.__converters.toInstant(_tmp_2);
                    long _tmp_3 = cursor.getLong(_cursorIndexOfTimestampUpdated);
                    Instant _tmpTimestampUpdated = LogDao_Impl.this.__converters.toInstant(_tmp_3);
                    String _tmp_4 = cursor.isNull(_cursorIndexOfThrowable) ? null : cursor.getString(_cursorIndexOfThrowable);
                    LogEntity.Throwable _tmpThrowable = _tmp_4 == null ? null : LogDao_Impl.this.__converters.toThrowable(_tmp_4);
                    int _tmp_5 = cursor.getInt(_cursorIndexOfUploaded);
                    boolean _tmpUploaded = _tmp_5 != 0;
                    LogEntity _item = new LogEntity(_tmpId, _tmpLevel, _tmpMessage, _tmpTag, _tmpTimestampCreated, _tmpTimestampUpdated, _tmpThrowable, _tmpUploaded);
                    _result.add(_item);
                }
                return _result;
            }
        };
    }

    @Override
    public Object getDatabaseSizeInfo(Continuation<? super List<SystemDatabaseSizeInfo>> $completion) {
        String _sql = "SELECT s.*, c.* FROM pragma_page_size as s JOIN pragma_page_count as c";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT s.*, c.* FROM pragma_page_size as s JOIN pragma_page_count as c", (int)0);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<SystemDatabaseSizeInfo>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<SystemDatabaseSizeInfo> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)LogDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfPageSizeBytes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"page_size");
                    int _cursorIndexOfPageCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"page_count");
                    ArrayList<SystemDatabaseSizeInfo> _result = new ArrayList<SystemDatabaseSizeInfo>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Integer _tmpPageSizeBytes = _cursor.isNull(_cursorIndexOfPageSizeBytes) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfPageSizeBytes));
                        Integer _tmpPageCount = _cursor.isNull(_cursorIndexOfPageCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfPageCount));
                        SystemDatabaseSizeInfo _item = new SystemDatabaseSizeInfo(_tmpPageSizeBytes, _tmpPageCount);
                        _result.add(_item);
                    }
                    ArrayList<SystemDatabaseSizeInfo> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

