/*
 * Decompiled with CFR 0.152.
 */
package dev.turingcomplete.kotlinonetimepassword;

import dev.turingcomplete.kotlinonetimepassword.HmacAlgorithm;
import dev.turingcomplete.kotlinonetimepassword.RandomSecretGenerator;
import dev.turingcomplete.kotlinonetimepassword.TimeBasedOneTimePasswordConfig;
import dev.turingcomplete.kotlinonetimepassword.TimeBasedOneTimePasswordGenerator;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.commons.codec.binary.Base32;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ldev/turingcomplete/kotlinonetimepassword/GoogleAuthenticator;", "", "base32secret", "", "(Ljava/lang/String;)V", "", "([B)V", "timeBasedOneTimePasswordGenerator", "Ldev/turingcomplete/kotlinonetimepassword/TimeBasedOneTimePasswordGenerator;", "generate", "timestamp", "Ljava/util/Date;", "isValid", "", "code", "Companion", "kotlin-onetimepassword"})
public final class GoogleAuthenticator {
    private final TimeBasedOneTimePasswordGenerator timeBasedOneTimePasswordGenerator;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String generate(@NotNull Date timestamp) {
        Intrinsics.checkParameterIsNotNull((Object)timestamp, (String)"timestamp");
        return this.timeBasedOneTimePasswordGenerator.generate(timestamp);
    }

    public static /* synthetic */ String generate$default(GoogleAuthenticator googleAuthenticator, Date date, int n, Object object) {
        if ((n & 1) != 0) {
            date = new Date(System.currentTimeMillis());
        }
        return googleAuthenticator.generate(date);
    }

    public final boolean isValid(@NotNull String code, @NotNull Date timestamp) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        Intrinsics.checkParameterIsNotNull((Object)timestamp, (String)"timestamp");
        return Intrinsics.areEqual((Object)code, (Object)this.generate(timestamp));
    }

    public static /* synthetic */ boolean isValid$default(GoogleAuthenticator googleAuthenticator, String string, Date date, int n, Object object) {
        if ((n & 2) != 0) {
            date = new Date(System.currentTimeMillis());
        }
        return googleAuthenticator.isValid(string, date);
    }

    public GoogleAuthenticator(@NotNull byte[] base32secret) {
        Intrinsics.checkParameterIsNotNull((Object)base32secret, (String)"base32secret");
        HmacAlgorithm hmacAlgorithm = HmacAlgorithm.SHA1;
        TimeBasedOneTimePasswordConfig config = new TimeBasedOneTimePasswordConfig(30L, TimeUnit.SECONDS, 6, hmacAlgorithm);
        byte[] byArray = new Base32().decode(base32secret);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Base32().decode(base32secret)");
        this.timeBasedOneTimePasswordGenerator = new TimeBasedOneTimePasswordGenerator(byArray, config);
    }

    @Deprecated(message="Use ByteArray representation", replaceWith=@ReplaceWith(imports={}, expression="GoogleAuthenticator(ByteArray)"))
    public GoogleAuthenticator(@NotNull String base32secret) {
        Intrinsics.checkParameterIsNotNull((Object)base32secret, (String)"base32secret");
        String string = base32secret;
        GoogleAuthenticator googleAuthenticator = this;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        googleAuthenticator(byArray2);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Ldev/turingcomplete/kotlinonetimepassword/GoogleAuthenticator$Companion;", "", "()V", "createRandomSecret", "", "createRandomSecretAsByteArray", "", "kotlin-onetimepassword"})
    public static final class Companion {
        @Deprecated(message="Use ByteArray representation", replaceWith=@ReplaceWith(imports={}, expression="createRandomSecretAsByteArray()"))
        @NotNull
        public final String createRandomSecret() {
            byte[] randomSecret = new RandomSecretGenerator().createRandomSecret(10);
            String string = new Base32().encodeAsString(randomSecret);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Base32().encodeAsString(randomSecret)");
            return string;
        }

        @NotNull
        public final byte[] createRandomSecretAsByteArray() {
            byte[] randomSecret = new RandomSecretGenerator().createRandomSecret(10);
            byte[] byArray = new Base32().encode(randomSecret);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Base32().encode(randomSecret)");
            return byArray;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

