/*
 * Decompiled with CFR 0.152.
 */
package dev.turingcomplete.kotlinonetimepassword;

import dev.turingcomplete.kotlinonetimepassword.HmacOneTimePasswordConfig;
import java.nio.ByteBuffer;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ldev/turingcomplete/kotlinonetimepassword/HmacOneTimePasswordGenerator;", "", "secret", "", "config", "Ldev/turingcomplete/kotlinonetimepassword/HmacOneTimePasswordConfig;", "([BLdev/turingcomplete/kotlinonetimepassword/HmacOneTimePasswordConfig;)V", "generate", "", "counter", "", "isValid", "", "code", "kotlin-onetimepassword"})
public class HmacOneTimePasswordGenerator {
    private final byte[] secret;
    private final HmacOneTimePasswordConfig config;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String generate(long counter) {
        if (this.config.getCodeDigits() <= 0) {
            return "";
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(8).putLong(0, counter);
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"ByteBuffer.allocate(8).putLong(0, counter)");
        ByteBuffer message = byteBuffer;
        Mac mac = Mac.getInstance(this.config.getHmacAlgorithm().getMacAlgorithmName());
        byte by = 0;
        int n = 0;
        Mac $this$run = mac;
        boolean bl = false;
        $this$run.init(new SecretKeySpec(this.secret, "RAW"));
        byte[] hash = $this$run.doFinal(message.array());
        Intrinsics.checkExpressionValueIsNotNull((Object)hash, (String)"hash");
        by = ArraysKt.last((byte[])hash);
        n = 15;
        int n2 = 0;
        byte offset = (byte)(by & n);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(4);
        n2 = 0;
        boolean bl2 = false;
        ByteBuffer $this$apply = byteBuffer2;
        boolean bl3 = false;
        int n3 = 0;
        int n4 = 3;
        while (n3 <= n4) {
            void i;
            $this$apply.put((int)i, hash[i + offset]);
            ++i;
        }
        ByteBuffer binary = byteBuffer2;
        byte by2 = binary.get(0);
        n2 = 127;
        int n5 = 0;
        ByteBuffer byteBuffer3 = binary;
        bl2 = false;
        byte by3 = (byte)(by2 & n2);
        byteBuffer3.put(n5, by3);
        ByteBuffer byteBuffer4 = binary;
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer4, (String)"binary");
        double d = 10.0;
        int n6 = this.config.getCodeDigits();
        int n7 = byteBuffer4.getInt();
        boolean bl4 = false;
        double d2 = Math.pow(d, n6);
        int codeInt = n7 % (int)d2;
        return StringsKt.padStart((String)String.valueOf(codeInt), (int)this.config.getCodeDigits(), (char)'0');
    }

    public final boolean isValid(@NotNull String code, long counter) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        return Intrinsics.areEqual((Object)code, (Object)this.generate(counter));
    }

    public HmacOneTimePasswordGenerator(@NotNull byte[] secret, @NotNull HmacOneTimePasswordConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)secret, (String)"secret");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.secret = secret;
        this.config = config;
    }
}

