/*
 * Decompiled with CFR 0.152.
 */
package dev.turingcomplete.kotlinonetimepassword;

import dev.turingcomplete.kotlinonetimepassword.HmacOneTimePasswordConfig;
import dev.turingcomplete.kotlinonetimepassword.OtpAuthUriBuilder;
import java.nio.ByteBuffer;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.codec.binary.Base32;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ldev/turingcomplete/kotlinonetimepassword/HmacOneTimePasswordGenerator;", "", "secret", "", "config", "Ldev/turingcomplete/kotlinonetimepassword/HmacOneTimePasswordConfig;", "([BLdev/turingcomplete/kotlinonetimepassword/HmacOneTimePasswordConfig;)V", "generate", "", "counter", "", "isValid", "", "code", "otpAuthUriBuilder", "Ldev/turingcomplete/kotlinonetimepassword/OtpAuthUriBuilder$Hotp;", "initialCounter", "kotlin-onetimepassword"})
public class HmacOneTimePasswordGenerator {
    @NotNull
    private final byte[] secret;
    @NotNull
    private final HmacOneTimePasswordConfig config;

    public HmacOneTimePasswordGenerator(@NotNull byte[] secret, @NotNull HmacOneTimePasswordConfig config) {
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.secret = secret;
        this.config = config;
    }

    @NotNull
    public final String generate(long counter) {
        if (this.config.getCodeDigits() <= 0) {
            return "";
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(8).putLong(0, counter);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"allocate(8).putLong(0, counter)");
        ByteBuffer message = byteBuffer;
        Mac $this$generate_u24lambda_u2d0 = Mac.getInstance(this.config.getHmacAlgorithm().getMacAlgorithmName());
        boolean bl = false;
        $this$generate_u24lambda_u2d0.init(new SecretKeySpec(this.secret, "RAW"));
        byte[] hash = $this$generate_u24lambda_u2d0.doFinal(message.array());
        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"hash");
        byte offset = (byte)(ArraysKt.last((byte[])hash) & 0xF);
        ByteBuffer $this$generate_u24lambda_u2d1 = bl = ByteBuffer.allocate(4);
        boolean bl2 = false;
        for (int i = 0; i < 4; ++i) {
            $this$generate_u24lambda_u2d1.put(i, hash[i + offset]);
        }
        ByteBuffer binary = bl;
        binary.put(0, (byte)(binary.get(0) & 0x7F));
        int codeInt = binary.getInt() % (int)Math.pow(10.0, this.config.getCodeDigits());
        return StringsKt.padStart((String)String.valueOf(codeInt), (int)this.config.getCodeDigits(), (char)'0');
    }

    public final boolean isValid(@NotNull String code, long counter) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        return Intrinsics.areEqual((Object)code, (Object)this.generate(counter));
    }

    @NotNull
    public final OtpAuthUriBuilder.Hotp otpAuthUriBuilder(long initialCounter) {
        byte[] byArray = new Base32().encode(this.secret);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Base32().encode(secret)");
        return (OtpAuthUriBuilder.Hotp)((OtpAuthUriBuilder.Hotp)OtpAuthUriBuilder.Companion.forHotp(initialCounter, byArray).algorithm(this.config.getHmacAlgorithm())).digits(this.config.getCodeDigits());
    }
}

