/*
 * Decompiled with CFR 0.152.
 */
package dev.turingcomplete.kotlinonetimepassword;

import dev.turingcomplete.kotlinonetimepassword.HmacAlgorithm;
import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\b\n\u0002\b\n\b\u0016\u0018\u0000 %*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00002\u00020\u0002:\u0003%&'B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u0006\u0010\u0016\u001a\u00020\u0006J\u0006\u0010\u0017\u001a\u00020\u0004J\u0006\u0010\u0018\u001a\u00020\u0019J\u001e\u0010\u001a\u001a\u00020\u00042\u0014\b\u0002\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001cH\u0002J\u0013\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\u0002\u0010\u001fJ\u0013\u0010 \u001a\u00028\u00002\u0006\u0010 \u001a\u00020\u0004\u00a2\u0006\u0002\u0010!J'\u0010\f\u001a\u00028\u00002\u0006\u0010\"\u001a\u00020\u00042\b\u0010 \u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010#\u001a\u00020\b\u00a2\u0006\u0002\u0010$J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Ldev/turingcomplete/kotlinonetimepassword/OtpAuthUriBuilder;", "S", "", "type", "", "base32Secret", "", "removePaddingFromBase32Secret", "", "charset", "Ljava/nio/charset/Charset;", "(Ljava/lang/String;[BZLjava/nio/charset/Charset;)V", "label", "parameters", "", "getParameters", "()Ljava/util/Map;", "setParameters", "(Ljava/util/Map;)V", "algorithm", "Ldev/turingcomplete/kotlinonetimepassword/HmacAlgorithm;", "(Ldev/turingcomplete/kotlinonetimepassword/HmacAlgorithm;)Ldev/turingcomplete/kotlinonetimepassword/OtpAuthUriBuilder;", "buildToByteArray", "buildToString", "buildToUri", "Ljava/net/URI;", "buildUriWithoutSecret", "additionalParameters", "", "digits", "", "(I)Ldev/turingcomplete/kotlinonetimepassword/OtpAuthUriBuilder;", "issuer", "(Ljava/lang/String;)Ldev/turingcomplete/kotlinonetimepassword/OtpAuthUriBuilder;", "accountName", "encodeSeparator", "(Ljava/lang/String;Ljava/lang/String;Z)Ldev/turingcomplete/kotlinonetimepassword/OtpAuthUriBuilder;", "Companion", "Hotp", "Totp", "kotlin-onetimepassword"})
public class OtpAuthUriBuilder<S extends OtpAuthUriBuilder<S>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String type;
    @NotNull
    private final Charset charset;
    @NotNull
    private final byte[] base32Secret;
    @Nullable
    private String label;
    @NotNull
    private Map<String, String> parameters;

    public OtpAuthUriBuilder(@NotNull String type, @NotNull byte[] base32Secret, boolean removePaddingFromBase32Secret, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)base32Secret, (String)"base32Secret");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        this.type = type;
        this.charset = charset;
        this.parameters = new LinkedHashMap();
        this.base32Secret = removePaddingFromBase32Secret ? this.removePaddingFromBase32Secret(base32Secret) : base32Secret;
    }

    public /* synthetic */ OtpAuthUriBuilder(String string, byte[] byArray, boolean bl, Charset charset, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            Charset charset2 = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
            charset = charset2;
        }
        this(string, byArray, bl, charset);
    }

    @NotNull
    protected final Map<String, String> getParameters() {
        return this.parameters;
    }

    protected final void setParameters(@NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.parameters = map;
    }

    @NotNull
    public final S label(@NotNull String accountName, @Nullable String issuer, boolean encodeSeparator) {
        String string;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)accountName, (String)"accountName");
                if (StringsKt.contains$default((CharSequence)accountName, (CharSequence)":", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)accountName, (CharSequence)"%3A", (boolean)false, (int)2, null)) break block5;
                String string2 = issuer;
                if (string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)":", (boolean)false, (int)2, null) : false) break block5;
                String string3 = issuer;
                boolean bl = string3 != null ? StringsKt.contains$default((CharSequence)string3, (CharSequence)"%3A", (boolean)false, (int)2, null) : false;
                if (!bl) break block6;
            }
            throw new IllegalArgumentException("Neither the account name nor the issuer are allowed to contain a colon.");
        }
        String encodedAccountName = URLEncoder.encode(accountName, this.charset.name());
        if (issuer != null) {
            String colon = encodeSeparator ? "%3A" : ":";
            string = URLEncoder.encode(issuer, this.charset.name()) + colon + encodedAccountName;
        } else {
            string = encodedAccountName;
        }
        this.label = string;
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type S of dev.turingcomplete.kotlinonetimepassword.OtpAuthUriBuilder");
        return (S)this;
    }

    public static /* synthetic */ OtpAuthUriBuilder label$default(OtpAuthUriBuilder otpAuthUriBuilder, String string, String string2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: label");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return otpAuthUriBuilder.label(string, string2, bl);
    }

    @NotNull
    public final S issuer(@NotNull String issuer) {
        Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
        Map<String, String> map = this.parameters;
        String string = "issuer";
        String string2 = URLEncoder.encode(issuer, StandardCharsets.UTF_8.name());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encode(issuer, StandardCharsets.UTF_8.name())");
        String string3 = string2;
        map.put(string, string3);
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type S of dev.turingcomplete.kotlinonetimepassword.OtpAuthUriBuilder");
        return (S)this;
    }

    @NotNull
    public final S algorithm(@NotNull HmacAlgorithm algorithm) {
        Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
        this.parameters.put("algorithm", algorithm.name());
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type S of dev.turingcomplete.kotlinonetimepassword.OtpAuthUriBuilder");
        return (S)this;
    }

    @NotNull
    public final S digits(int digits) {
        this.parameters.put("digits", String.valueOf(digits));
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type S of dev.turingcomplete.kotlinonetimepassword.OtpAuthUriBuilder");
        return (S)this;
    }

    @NotNull
    public final String buildToString() {
        return this.buildUriWithoutSecret(MapsKt.mapOf((Pair)new Pair((Object)"secret", (Object)new String(this.base32Secret, this.charset))));
    }

    @NotNull
    public final URI buildToUri() {
        return new URI(this.buildToString());
    }

    @NotNull
    public final byte[] buildToByteArray() {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream $this$buildToByteArray_u24lambda_u2d0 = byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        byte[] byArray = OtpAuthUriBuilder.buildUriWithoutSecret$default(this, null, 1, null).getBytes(this.charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        $this$buildToByteArray_u24lambda_u2d0.write(byArray);
        $this$buildToByteArray_u24lambda_u2d0.write(!this.parameters.isEmpty() ? 38 : 63);
        byte[] byArray2 = "secret=".getBytes(this.charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
        $this$buildToByteArray_u24lambda_u2d0.write(byArray2);
        $this$buildToByteArray_u24lambda_u2d0.write(this.base32Secret);
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"ByteArrayOutputStream().\u2026cret)\n    }.toByteArray()");
        return byArray3;
    }

    /*
     * WARNING - void declaration
     */
    private final String buildUriWithoutSecret(Map<String, String> additionalParameters) {
        void $this$mapTo$iv$iv;
        Map $this$map$iv = MapsKt.plus(this.parameters, additionalParameters);
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getKey() + '=' + (String)it.getValue());
        }
        String query = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", (CharSequence)"?", null, (int)0, null, null, (int)60, null);
        return "otpauth://" + this.type + '/' + (this.label != null ? this.label + '/' : "") + query;
    }

    static /* synthetic */ String buildUriWithoutSecret$default(OtpAuthUriBuilder otpAuthUriBuilder, Map map, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildUriWithoutSecret");
        }
        if ((n & 1) != 0) {
            map = MapsKt.emptyMap();
        }
        return otpAuthUriBuilder.buildUriWithoutSecret(map);
    }

    private final byte[] removePaddingFromBase32Secret(byte[] base32Secret) {
        ByteBuffer base32SecretByteBuffer = ByteBuffer.wrap(base32Secret);
        CharBuffer charBuffer = this.charset.decode(base32SecretByteBuffer);
        Intrinsics.checkNotNullExpressionValue((Object)charBuffer, (String)"charset.decode(base32SecretByteBuffer)");
        CharBuffer base32SecretCharBuffer = charBuffer;
        int cleanedBase32SecretLength = 0;
        CharBuffer cleanedBase32SecretCharBuffer = CharBuffer.allocate(base32SecretCharBuffer.length());
        int n = base32SecretCharBuffer.length();
        for (int i = 0; i < n; ++i) {
            if (base32SecretCharBuffer.get(i) == '=') continue;
            ++cleanedBase32SecretLength;
            cleanedBase32SecretCharBuffer.put(i, base32SecretCharBuffer.get(i));
        }
        ByteBuffer cleanedBase32SecretByteBuffer = this.charset.encode(cleanedBase32SecretCharBuffer.subSequence(0, cleanedBase32SecretLength));
        byte[] cleanedBase32Secret = Arrays.copyOfRange(cleanedBase32SecretByteBuffer.array(), cleanedBase32SecretByteBuffer.position(), cleanedBase32SecretByteBuffer.limit());
        Arrays.fill(base32SecretCharBuffer.array(), '-');
        Arrays.fill(cleanedBase32SecretCharBuffer.array(), '-');
        Arrays.fill(cleanedBase32SecretByteBuffer.array(), (byte)0);
        Intrinsics.checkNotNullExpressionValue((Object)cleanedBase32Secret, (String)"cleanedBase32Secret");
        return cleanedBase32Secret;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u000b"}, d2={"Ldev/turingcomplete/kotlinonetimepassword/OtpAuthUriBuilder$Companion;", "", "()V", "forHotp", "Ldev/turingcomplete/kotlinonetimepassword/OtpAuthUriBuilder$Hotp;", "initialCounter", "", "base32Secret", "", "forTotp", "Ldev/turingcomplete/kotlinonetimepassword/OtpAuthUriBuilder$Totp;", "kotlin-onetimepassword"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Totp forTotp(@NotNull byte[] base32Secret) {
            Intrinsics.checkNotNullParameter((Object)base32Secret, (String)"base32Secret");
            return new Totp(base32Secret);
        }

        @NotNull
        public final Hotp forHotp(long initialCounter, @NotNull byte[] base32Secret) {
            Intrinsics.checkNotNullParameter((Object)base32Secret, (String)"base32Secret");
            return new Hotp(initialCounter, base32Secret);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Ldev/turingcomplete/kotlinonetimepassword/OtpAuthUriBuilder$Totp;", "Ldev/turingcomplete/kotlinonetimepassword/OtpAuthUriBuilder;", "base32Secret", "", "([B)V", "period", "timeStep", "", "timeStepUnit", "Ljava/util/concurrent/TimeUnit;", "kotlin-onetimepassword"})
    public static final class Totp
    extends OtpAuthUriBuilder<Totp> {
        public Totp(@NotNull byte[] base32Secret) {
            Intrinsics.checkNotNullParameter((Object)base32Secret, (String)"base32Secret");
            super("totp", base32Secret, false, null, 12, null);
        }

        @NotNull
        public final Totp period(long timeStep, @NotNull TimeUnit timeStepUnit) {
            Intrinsics.checkNotNullParameter((Object)((Object)timeStepUnit), (String)"timeStepUnit");
            this.getParameters().put("period", String.valueOf(timeStepUnit.toSeconds(timeStep)));
            return this;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\b"}, d2={"Ldev/turingcomplete/kotlinonetimepassword/OtpAuthUriBuilder$Hotp;", "Ldev/turingcomplete/kotlinonetimepassword/OtpAuthUriBuilder;", "initialCounter", "", "base32Secret", "", "(J[B)V", "counter", "kotlin-onetimepassword"})
    public static final class Hotp
    extends OtpAuthUriBuilder<Hotp> {
        public Hotp(long initialCounter, @NotNull byte[] base32Secret) {
            Intrinsics.checkNotNullParameter((Object)base32Secret, (String)"base32Secret");
            super("hotp", base32Secret, false, null, 12, null);
            this.counter(initialCounter);
        }

        @NotNull
        public final Hotp counter(long initialCounter) {
            this.getParameters().put("counter", String.valueOf(initialCounter));
            return this;
        }
    }
}

