/*
 * Decompiled with CFR 0.152.
 */
package dev.turingcomplete.kotlinonetimepassword;

import dev.turingcomplete.kotlinonetimepassword.HmacOneTimePasswordGenerator;
import dev.turingcomplete.kotlinonetimepassword.OtpAuthUriBuilder;
import dev.turingcomplete.kotlinonetimepassword.TimeBasedOneTimePasswordConfig;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.codec.binary.Base32;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000f\u001a\u00020\nJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u000f\u001a\u00020\nJ\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\b\b\u0002\u0010\u000f\u001a\u00020\nJ\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ldev/turingcomplete/kotlinonetimepassword/TimeBasedOneTimePasswordGenerator;", "", "secret", "", "config", "Ldev/turingcomplete/kotlinonetimepassword/TimeBasedOneTimePasswordConfig;", "([BLdev/turingcomplete/kotlinonetimepassword/TimeBasedOneTimePasswordConfig;)V", "hmacOneTimePasswordGenerator", "Ldev/turingcomplete/kotlinonetimepassword/HmacOneTimePasswordGenerator;", "counter", "", "instant", "Ljava/time/Instant;", "date", "Ljava/util/Date;", "timestamp", "generate", "", "isValid", "", "code", "otpAuthUriBuilder", "Ldev/turingcomplete/kotlinonetimepassword/OtpAuthUriBuilder$Totp;", "timeslotStart", "kotlin-onetimepassword"})
public class TimeBasedOneTimePasswordGenerator {
    @NotNull
    private final byte[] secret;
    @NotNull
    private final TimeBasedOneTimePasswordConfig config;
    @NotNull
    private final HmacOneTimePasswordGenerator hmacOneTimePasswordGenerator;

    public TimeBasedOneTimePasswordGenerator(@NotNull byte[] secret, @NotNull TimeBasedOneTimePasswordConfig config) {
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.secret = secret;
        this.config = config;
        this.hmacOneTimePasswordGenerator = new HmacOneTimePasswordGenerator(this.secret, this.config);
    }

    public final long counter(long timestamp) {
        if (this.config.getTimeStep() == 0L) {
            return 0L;
        }
        return (long)Math.floor((double)timestamp / (double)TimeUnit.MILLISECONDS.convert(this.config.getTimeStep(), this.config.getTimeStepUnit()));
    }

    public static /* synthetic */ long counter$default(TimeBasedOneTimePasswordGenerator timeBasedOneTimePasswordGenerator, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: counter");
        }
        if ((n & 1) != 0) {
            l = System.currentTimeMillis();
        }
        return timeBasedOneTimePasswordGenerator.counter(l);
    }

    public final long counter(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return this.counter(date.getTime());
    }

    public final long counter(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        return this.counter(instant.toEpochMilli());
    }

    public final long timeslotStart(long counter) {
        double timeStepMillis = TimeUnit.MILLISECONDS.convert(this.config.getTimeStep(), this.config.getTimeStepUnit());
        return (long)((double)counter * timeStepMillis);
    }

    @NotNull
    public final String generate(long timestamp) {
        return this.hmacOneTimePasswordGenerator.generate(this.counter(timestamp));
    }

    public static /* synthetic */ String generate$default(TimeBasedOneTimePasswordGenerator timeBasedOneTimePasswordGenerator, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: generate");
        }
        if ((n & 1) != 0) {
            l = System.currentTimeMillis();
        }
        return timeBasedOneTimePasswordGenerator.generate(l);
    }

    @NotNull
    public final String generate(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return this.generate(date.getTime());
    }

    @NotNull
    public final String generate(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        return this.generate(instant.toEpochMilli());
    }

    public final boolean isValid(@NotNull String code, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        return Intrinsics.areEqual((Object)code, (Object)this.generate(timestamp));
    }

    public static /* synthetic */ boolean isValid$default(TimeBasedOneTimePasswordGenerator timeBasedOneTimePasswordGenerator, String string, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: isValid");
        }
        if ((n & 2) != 0) {
            l = System.currentTimeMillis();
        }
        return timeBasedOneTimePasswordGenerator.isValid(string, l);
    }

    public final boolean isValid(@NotNull String code, @NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return this.isValid(code, date.getTime());
    }

    public final boolean isValid(@NotNull String code, @NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        return this.isValid(code, instant.toEpochMilli());
    }

    @NotNull
    public final OtpAuthUriBuilder.Totp otpAuthUriBuilder() {
        byte[] byArray = new Base32().encode(this.secret);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Base32().encode(secret)");
        return ((OtpAuthUriBuilder.Totp)((OtpAuthUriBuilder.Totp)OtpAuthUriBuilder.Companion.forTotp(byArray).algorithm(this.config.getHmacAlgorithm())).digits(this.config.getCodeDigits())).period(this.config.getTimeStep(), this.config.getTimeStepUnit());
    }
}

