/*
 * Decompiled with CFR 0.152.
 */
package dev.vankka.dependencydownload.jarinjar.classloader;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class JarInJarClassLoader
extends URLClassLoader {
    public JarInJarClassLoader(String tempFilePrefix, URL resourceURL, ClassLoader parent) throws IOException {
        super(new URL[]{JarInJarClassLoader.asTempFileURL(tempFilePrefix, resourceURL)}, parent);
    }

    private static URL asTempFileURL(String filePrefix, URL resourceURL) throws IOException {
        if (filePrefix == null) {
            throw new NullPointerException("filePrefix");
        }
        if (resourceURL == null) {
            throw new NullPointerException("resourceURL");
        }
        Path tempFile = Files.createTempFile(filePrefix, ".jar.tmp", new FileAttribute[0]);
        try (InputStream inputStream = resourceURL.openStream();){
            Files.copy(inputStream, tempFile, StandardCopyOption.REPLACE_EXISTING);
        }
        tempFile.toFile().deleteOnExit();
        return tempFile.toUri().toURL();
    }

    @Override
    public void close() throws IOException {
        super.close();
        URL url = this.getURLs()[0];
        if (url != null) {
            Path path;
            try {
                path = Paths.get(url.toURI());
            }
            catch (URISyntaxException ignored) {
                return;
            }
            Files.deleteIfExists(path);
        }
    }

    public void addURL(Path path) throws MalformedURLException {
        this.addURL(path.toUri().toURL());
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

