/*
 * Decompiled with CFR 0.152.
 */
package dev.vankka.dependencydownload.jarinjar.loader;

import dev.vankka.dependencydownload.jarinjar.classloader.JarInJarClassLoader;
import dev.vankka.dependencydownload.jarinjar.loader.exception.LoadingException;
import java.io.IOException;
import java.net.URL;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;

public interface ILoader {
    @MustBeInvokedByOverriders
    @ApiStatus.NonExtendable
    default public @UnknownNullability(value="Not null unless handleLoadingException is modified") JarInJarClassLoader initialize() {
        try {
            JarInJarClassLoader classLoader = this.createClassLoader();
            Class clazz = classLoader.loadClass(this.getBootstrapClassName());
            this.initiateBootstrap(clazz, classLoader);
            return classLoader;
        }
        catch (Throwable t) {
            this.handleLoadingException(new LoadingException("Unable to load JarInJar", t));
            return null;
        }
    }

    default public void handleLoadingException(@NotNull LoadingException exception) {
        throw exception;
    }

    @NotNull
    default public JarInJarClassLoader createClassLoader() throws IOException {
        return new JarInJarClassLoader(this.getName(), this.getJarInJarResource(), this.getParentClassLoader());
    }

    @NotNull
    default public ClassLoader getParentClassLoader() {
        return this.getClass().getClassLoader();
    }

    public void initiateBootstrap(@NotNull Class<?> var1, @NotNull JarInJarClassLoader var2) throws ReflectiveOperationException;

    @NotNull
    public String getBootstrapClassName();

    @NotNull
    public String getName();

    @NotNull
    public URL getJarInJarResource();
}

