/*
 * Decompiled with CFR 0.152.
 */
package dev.vankka.dependencydownload;

import dev.vankka.dependencydownload.DependencyManager;
import dev.vankka.dependencydownload.dependency.Dependency;
import dev.vankka.dependencydownload.logger.Logger;
import dev.vankka.dependencydownload.path.DependencyPathProvider;
import dev.vankka.dependencydownload.relocation.Relocation;
import dev.vankka.dependencydownload.resource.DependencyDownloadResource;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.NotNull;

public class ApplicationDependencyManager {
    private final DependencyManager dependencyManager;

    public ApplicationDependencyManager(@NotNull DependencyPathProvider dependencyPathProvider) {
        this(dependencyPathProvider, Logger.NOOP);
    }

    public ApplicationDependencyManager(@NotNull DependencyPathProvider dependencyPathProvider, Logger logger) {
        this.dependencyManager = new DependencyManager(dependencyPathProvider, logger);
    }

    @NotNull
    public DependencyPathProvider getDependencyPathProvider() {
        return this.dependencyManager.getDependencyPathProvider();
    }

    @NotNull
    public Logger getLogger() {
        return this.dependencyManager.getLogger();
    }

    @NotNull
    public ApplicationDependencyManager addRelocations(Relocation ... relocations) {
        return this.addRelocations(Arrays.asList(relocations));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ApplicationDependencyManager addRelocations(@NotNull Collection<Relocation> relocations) {
        DependencyManager dependencyManager = this.dependencyManager;
        synchronized (dependencyManager) {
            this.dependencyManager.addRelocations(relocations);
        }
        return this;
    }

    @CheckReturnValue
    @NotNull
    public DependencyManager includeResource(@NotNull DependencyDownloadResource resource) {
        this.addRelocations(resource.getRelocations());
        return this.include(resource.getDependencies());
    }

    @CheckReturnValue
    @NotNull
    public DependencyManager include(Dependency ... dependencies) {
        return this.include(Arrays.asList(dependencies));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    @NotNull
    public DependencyManager include(@NotNull Collection<Dependency> dependencies) {
        dependencies = this.addMissingDependencies(dependencies);
        DependencyManager dependencyManager = new DependencyManager(this.getDependencyPathProvider(), this.getLogger());
        dependencyManager.addDependencies(dependencies);
        DependencyManager dependencyManager2 = this.dependencyManager;
        synchronized (dependencyManager2) {
            dependencyManager.addRelocations(this.dependencyManager.getRelocations());
        }
        return dependencyManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public DependencyManager include(@NotNull DependencyManager manager) {
        this.addRelocations(manager.getRelocations());
        List<Dependency> dependencies = this.addMissingDependencies(manager.getDependencies());
        if (manager.isLoaded()) {
            return manager;
        }
        DependencyManager dependencyManager = new DependencyManager(manager.getDependencyPathProvider(), manager.getLogger());
        dependencyManager.addDependencies(dependencies);
        DependencyManager dependencyManager2 = this.dependencyManager;
        synchronized (dependencyManager2) {
            dependencyManager.addRelocations(this.dependencyManager.getRelocations());
        }
        return dependencyManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Path getPathForDependency(@NotNull Dependency dependency, boolean relocated) {
        DependencyManager dependencyManager = this.dependencyManager;
        synchronized (dependencyManager) {
            return this.dependencyManager.getPathForDependency(dependency, relocated);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Set<Path> getPaths(boolean relocated) {
        DependencyManager dependencyManager = this.dependencyManager;
        synchronized (dependencyManager) {
            return this.dependencyManager.getPaths(relocated);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Set<Path> getAllPaths(boolean includeRelocated) {
        DependencyManager dependencyManager = this.dependencyManager;
        synchronized (dependencyManager) {
            return this.dependencyManager.getAllPaths(includeRelocated);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupCacheDirectory() throws IOException, IllegalStateException {
        DependencyManager dependencyManager = this.dependencyManager;
        synchronized (dependencyManager) {
            this.dependencyManager.cleanupCacheDirectory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Dependency> addMissingDependencies(Collection<Dependency> old) {
        ArrayList<Dependency> missingDependencies = new ArrayList<Dependency>(old.size());
        for (Dependency dependency : old) {
            String group = dependency.getGroupId();
            String artifact = dependency.getArtifactId();
            DependencyManager dependencyManager = this.dependencyManager;
            synchronized (dependencyManager) {
                boolean noMatch = this.dependencyManager.getDependencies().stream().noneMatch(dep -> dep.getGroupId().equals(group) && dep.getArtifactId().equals(artifact));
                if (noMatch) {
                    missingDependencies.add(dependency);
                    this.dependencyManager.addDependencies(dependency);
                }
            }
        }
        return missingDependencies;
    }
}

