/*
 * Decompiled with CFR 0.152.
 */
package dev.vankka.dependencydownload;

import dev.vankka.dependencydownload.classpath.ClasspathAppender;
import dev.vankka.dependencydownload.common.util.HashUtil;
import dev.vankka.dependencydownload.dependency.Dependency;
import dev.vankka.dependencydownload.logger.Logger;
import dev.vankka.dependencydownload.path.CleanupPathProvider;
import dev.vankka.dependencydownload.path.DependencyPathProvider;
import dev.vankka.dependencydownload.relocation.Relocation;
import dev.vankka.dependencydownload.repository.Repository;
import dev.vankka.dependencydownload.resource.DependencyDownloadResource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencyManager {
    private final DependencyPathProvider dependencyPathProvider;
    private final Logger logger;
    private final List<Dependency> dependencies = new CopyOnWriteArrayList<Dependency>();
    private final List<Relocation> relocations = new CopyOnWriteArrayList<Relocation>();
    private final AtomicInteger step = new AtomicInteger(0);

    public DependencyManager(@NotNull DependencyPathProvider dependencyPathProvider) {
        this(dependencyPathProvider, Logger.NOOP);
    }

    public DependencyManager(@NotNull DependencyPathProvider dependencyPathProvider, @NotNull Logger logger) {
        this.dependencyPathProvider = dependencyPathProvider;
        this.logger = logger;
    }

    @NotNull
    public DependencyPathProvider getDependencyPathProvider() {
        return this.dependencyPathProvider;
    }

    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    public DependencyManager addDependencies(Dependency ... dependencies) {
        return this.addDependencies(Arrays.asList(dependencies));
    }

    public DependencyManager addDependencies(@NotNull Collection<Dependency> dependencies) {
        if (this.step.get() > 0) {
            throw new IllegalStateException("Cannot add dependencies after downloading");
        }
        this.dependencies.addAll(dependencies);
        return this;
    }

    @NotNull
    public List<Dependency> getDependencies() {
        return Collections.unmodifiableList(this.dependencies);
    }

    public DependencyManager addRelocations(Relocation ... relocations) {
        return this.addRelocations(Arrays.asList(relocations));
    }

    public DependencyManager addRelocations(@NotNull Collection<Relocation> relocations) {
        if (this.step.get() > 2) {
            throw new IllegalStateException("Cannot add relocations after relocating");
        }
        this.relocations.addAll(relocations);
        return this;
    }

    @NotNull
    public List<Relocation> getRelocations() {
        return Collections.unmodifiableList(this.relocations);
    }

    public boolean isLoaded() {
        return this.step.get() == 3;
    }

    public DependencyManager loadResource(@NotNull DependencyDownloadResource resource) {
        this.dependencies.addAll(resource.getDependencies());
        this.relocations.addAll(resource.getRelocations());
        return this;
    }

    public CompletableFuture<Void> downloadAll(@Nullable Executor executor, @NotNull List<Repository> repositories) {
        return CompletableFuture.allOf(this.download(executor, repositories));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void>[] download(@Nullable Executor executor, @NotNull List<Repository> repositories) {
        if (repositories.isEmpty()) {
            throw new IllegalArgumentException("No repositories provided");
        }
        if (!this.step.compareAndSet(0, 1)) {
            throw new IllegalStateException("Download has already been executed");
        }
        this.logger.downloadStart();
        try {
            CompletableFuture<Void>[] completableFutureArray = this.forEachDependency(executor, dependency -> this.downloadDependency((Dependency)dependency, repositories, () -> this.logger.downloadDependency((Dependency)dependency)), (dependency, cause) -> new RuntimeException("Failed to download dependency " + dependency.getGAV(), (Throwable)cause), this.logger::downloadSuccess, this.logger::downloadFailed);
            return completableFutureArray;
        }
        finally {
            this.logger.downloadEnd();
        }
    }

    public CompletableFuture<Void> relocateAll(@Nullable Executor executor) {
        return CompletableFuture.allOf(this.relocate(executor, this.getClass().getClassLoader()));
    }

    public CompletableFuture<Void> relocateAll(@Nullable Executor executor, @Nullable ClassLoader jarRelocatorLoader) {
        return CompletableFuture.allOf(this.relocate(executor, jarRelocatorLoader));
    }

    public CompletableFuture<Void>[] relocate(@Nullable Executor executor) {
        return this.relocate(executor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void>[] relocate(@Nullable Executor executor, @Nullable ClassLoader jarRelocatorLoader) {
        int currentStep = this.step.getAndUpdate(current -> current == 1 ? 2 : current);
        if (currentStep == 0) {
            throw new IllegalStateException("Download hasn't been executed");
        }
        if (currentStep == 2) {
            throw new IllegalStateException("Already relocated");
        }
        if (currentStep == 3) {
            throw new IllegalStateException("Cannot relocate after loading");
        }
        JarRelocatorHelper helper = new JarRelocatorHelper(jarRelocatorLoader != null ? jarRelocatorLoader : this.getClass().getClassLoader(), this.relocations);
        try {
            this.logger.relocateStart();
            CompletableFuture<Void>[] completableFutureArray = this.forEachDependency(executor, dependency -> {
                this.logger.relocateDependency((Dependency)dependency);
                return this.relocateDependency((Dependency)dependency, helper);
            }, (dependency, cause) -> new RuntimeException("Failed to relocate dependency " + dependency.getGAV(), (Throwable)cause), this.logger::relocateSuccess, this.logger::relocateFailed);
            return completableFutureArray;
        }
        finally {
            this.logger.relocateEnd();
        }
    }

    public CompletableFuture<Void> loadAll(@Nullable Executor executor, @NotNull ClasspathAppender classpathAppender) {
        return CompletableFuture.allOf(this.load(executor, classpathAppender));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void>[] load(@Nullable Executor executor, @NotNull ClasspathAppender classpathAppender) {
        int currentStep = this.step.getAndUpdate(current -> current == 0 || current == 3 ? current : 3);
        if (currentStep == 0) {
            throw new IllegalStateException("Download hasn't been executed");
        }
        if (currentStep == 3) {
            throw new IllegalStateException("Already loaded");
        }
        try {
            this.logger.loadStart();
            CompletableFuture<Void>[] completableFutureArray = this.forEachDependency(executor, dependency -> {
                this.logger.loadDependency((Dependency)dependency);
                return this.loadDependency((Dependency)dependency, classpathAppender, currentStep == 2);
            }, (dependency, cause) -> new RuntimeException("Failed to load dependency " + dependency.getGAV(), (Throwable)cause), this.logger::loadSuccess, this.logger::loadFailed);
            return completableFutureArray;
        }
        finally {
            this.logger.loadEnd();
        }
    }

    @NotNull
    public Path getPathForDependency(@NotNull Dependency dependency, boolean relocated) {
        return this.getDependencyPathProvider().getDependencyPath(dependency, relocated);
    }

    @NotNull
    public Set<Path> getPaths(boolean relocated) {
        HashSet<Path> paths = new HashSet<Path>();
        for (Dependency dependency : this.dependencies) {
            paths.add(this.getPathForDependency(dependency, relocated));
        }
        return paths;
    }

    @NotNull
    public Set<Path> getAllPaths(boolean includeRelocated) {
        HashSet<Path> paths = new HashSet<Path>(this.getPaths(false));
        if (includeRelocated) {
            paths.addAll(this.getPaths(true));
        }
        return paths;
    }

    public void cleanupCacheDirectory() throws IOException, IllegalStateException {
        if (!(this.dependencyPathProvider instanceof CleanupPathProvider)) {
            throw new IllegalStateException("Cache directory cleanup is only available when dependencyPathProvider is a instance of CleanupPathProvider");
        }
        Collection<Path> existingPaths = ((CleanupPathProvider)this.dependencyPathProvider).getPathsForAllStoredDependencies();
        Set<Path> currentPaths = this.getAllPaths(true);
        for (Path existingPath : existingPaths) {
            if (Files.isDirectory(existingPath, new LinkOption[0]) || currentPaths.contains(existingPath)) continue;
            Files.delete(existingPath);
        }
    }

    private CompletableFuture<Void>[] forEachDependency(Executor executor, Step<Dependency> runnable, BiFunction<Dependency, Throwable, Throwable> dependencyException, Consumer<Dependency> successLog, BiConsumer<Dependency, Throwable> failLog) {
        int size = this.dependencies.size();
        CompletableFuture[] futures = new CompletableFuture[size];
        for (int index = 0; index < size; ++index) {
            Dependency dependency = this.dependencies.get(index);
            CompletableFuture future = new CompletableFuture();
            Runnable run = () -> {
                try {
                    boolean stepPerformed = runnable.run(dependency);
                    if (stepPerformed) {
                        successLog.accept(dependency);
                    }
                    future.complete(null);
                }
                catch (Throwable t) {
                    future.completeExceptionally((Throwable)dependencyException.apply(dependency, t));
                    failLog.accept(dependency, t);
                }
            };
            if (executor != null) {
                executor.execute(run);
            } else {
                run.run();
            }
            futures[index] = future;
            if (future.isCompletedExceptionally()) break;
        }
        return futures;
    }

    private boolean downloadDependency(Dependency dependency, List<Repository> repositories, Runnable beginDownloadCallback) throws IOException, NoSuchAlgorithmException {
        Path dependencyPath = this.getPathForDependency(dependency, false);
        if (!Files.exists(dependencyPath.getParent(), new LinkOption[0])) {
            Files.createDirectories(dependencyPath.getParent(), new FileAttribute[0]);
        }
        MessageDigest digest = MessageDigest.getInstance(dependency.getHashingAlgorithm());
        if (Files.exists(dependencyPath, new LinkOption[0])) {
            String fileHash = HashUtil.getFileHash((Path)dependencyPath, (MessageDigest)digest);
            if (fileHash.equals(dependency.getHash())) {
                return false;
            }
            Files.delete(dependencyPath);
        }
        beginDownloadCallback.run();
        Files.createFile(dependencyPath, new FileAttribute[0]);
        RuntimeException failure = new RuntimeException("All provided repositories failed to download dependency");
        boolean anyFailures = false;
        for (Repository repository : repositories) {
            try {
                digest.reset();
                this.downloadFromRepository(dependency, repository, dependencyPath, digest);
                String hash = HashUtil.getHash((MessageDigest)digest);
                String dependencyHash = dependency.getHash();
                if (!hash.equals(dependencyHash)) {
                    throw new SecurityException("Failed to verify file hash: " + hash + " should've been: " + dependencyHash);
                }
                return true;
            }
            catch (Exception e) {
                Files.deleteIfExists(dependencyPath);
                failure.addSuppressed(e);
                anyFailures = true;
            }
        }
        if (!anyFailures) {
            throw new IllegalStateException("Nothing failed yet nothing passed");
        }
        throw failure;
    }

    private void downloadFromRepository(Dependency dependency, Repository repository, Path dependencyPath, MessageDigest digest) throws IOException {
        URLConnection connection = repository.openConnection(dependency);
        byte[] buffer = new byte[repository.getBufferSize()];
        try (BufferedInputStream inputStream = new BufferedInputStream(connection.getInputStream());
             BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(dependencyPath, new OpenOption[0]));){
            int total;
            while ((total = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, total);
                digest.update(buffer, 0, total);
            }
        }
    }

    private boolean relocateDependency(Dependency dependency, JarRelocatorHelper helper) {
        Path dependencyFile = this.getPathForDependency(dependency, false);
        Path relocatedFile = this.getPathForDependency(dependency, true);
        try {
            helper.run(dependencyFile, relocatedFile);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Failed to run relocation", e.getCause());
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to initialize relocator", e);
        }
        return true;
    }

    private boolean loadDependency(Dependency dependency, ClasspathAppender classpathAppender, boolean relocated) throws MalformedURLException {
        Path fileToLoad = relocated ? this.getPathForDependency(dependency, true) : this.getPathForDependency(dependency, false);
        classpathAppender.appendFileToClasspath(fileToLoad);
        return true;
    }

    @FunctionalInterface
    private static interface Step<T> {
        public boolean run(T var1) throws Throwable;
    }

    private static class JarRelocatorHelper {
        private final Constructor<?> relocatorConstructor;
        private final Method relocatorRunMethod;
        private final List<Object> mappedRelocations;

        public JarRelocatorHelper(ClassLoader classLoader, List<Relocation> relocations) {
            try {
                Class<?> relocatorClass = classLoader.loadClass("me.lucko.jarrelocator.JarRelocator");
                this.relocatorConstructor = relocatorClass.getConstructor(File.class, File.class, Collection.class);
                this.relocatorRunMethod = relocatorClass.getMethod("run", new Class[0]);
                Class<?> relocationClass = classLoader.loadClass("me.lucko.jarrelocator.Relocation");
                Constructor<?> relocationConstructor = relocationClass.getConstructor(String.class, String.class, Collection.class, Collection.class);
                this.mappedRelocations = new ArrayList<Object>();
                for (Relocation relocation : relocations) {
                    Object mapped = relocationConstructor.newInstance(relocation.getPattern(), relocation.getShadedPattern(), relocation.getIncludes(), relocation.getExcludes());
                    this.mappedRelocations.add(mapped);
                }
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Failed to load jar-relocator from the provided ClassLoader", e);
            }
        }

        public void run(Path from, Path to) throws ReflectiveOperationException {
            Object relocator = this.relocatorConstructor.newInstance(from.toFile(), to.toFile(), this.mappedRelocations);
            this.relocatorRunMethod.invoke(relocator, new Object[0]);
        }
    }
}

