/*
 * Decompiled with CFR 0.152.
 */
package dev.vankka.dependencydownload.dependency;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Dependency {
    @NotNull
    public String getGroupId();

    @NotNull
    public String getArtifactId();

    @NotNull
    public String getVersion();

    @Nullable
    public String getClassifier();

    @Nullable
    public String getSnapshotVersion();

    @NotNull
    public String getHash();

    @NotNull
    public String getHashingAlgorithm();

    default public boolean isSnapshot() {
        return this.getSnapshotVersion() != null;
    }

    @NotNull
    default public String getFileName() {
        String classifier = this.getClassifier();
        String snapshotVersion = this.getSnapshotVersion();
        return this.getArtifactId() + '-' + (snapshotVersion != null ? snapshotVersion : this.getVersion()) + (classifier != null ? '-' + classifier : "") + ".jar";
    }

    @NotNull
    default public String getStoredFileName() {
        String classifier = this.getClassifier();
        return this.getGroupId() + '-' + this.getArtifactId() + '-' + this.getVersion() + (this.isSnapshot() ? "-" + this.getSnapshotVersion() : "") + (classifier != null ? '-' + classifier : "") + ".jar";
    }

    @NotNull
    default public String getGAV() {
        String classifier = this.getClassifier();
        return this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getVersion() + (classifier != null ? ":" + classifier : "");
    }
}

