/*
 * Decompiled with CFR 0.152.
 */
package dev.vankka.dependencydownload.dependency;

import dev.vankka.dependencydownload.dependency.Dependency;
import java.util.Objects;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MavenDependency
implements Dependency {
    private static final String MAVEN_PATH_FORMAT = "%s/%s/%s/%s";
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String classifier;
    private final String hash;
    private final String hashingAlgorithm;
    private final String snapshotVersion;

    public MavenDependency(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, @Nullable String classifier, @NotNull String hash, @NotNull String hashingAlgorithm) {
        this(groupId, artifactId, version, classifier, null, hash, hashingAlgorithm);
    }

    public MavenDependency(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, @Nullable String classifier, @Nullable @Pattern(value="[0-9]{8}\\.[0-9]{6}-[0-9]+") String snapshotVersion, @NotNull String hash, @NotNull String hashingAlgorithm) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.classifier = classifier;
        this.snapshotVersion = snapshotVersion;
        this.hash = hash;
        this.hashingAlgorithm = hashingAlgorithm;
    }

    @Override
    @NotNull
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    @NotNull
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    @NotNull
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getClassifier() {
        return this.classifier;
    }

    @Override
    public String getSnapshotVersion() {
        return this.snapshotVersion;
    }

    @Override
    @NotNull
    public String getHash() {
        return this.hash;
    }

    @Override
    @NotNull
    public String getHashingAlgorithm() {
        return this.hashingAlgorithm;
    }

    @NotNull
    public String getMavenPath() {
        return String.format(MAVEN_PATH_FORMAT, this.getGroupId().replace('.', '/'), this.getArtifactId(), this.getVersion(), this.getFileName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenDependency that = (MavenDependency)o;
        return Objects.equals(this.groupId, that.groupId) && Objects.equals(this.artifactId, that.artifactId) && Objects.equals(this.version, that.version) && Objects.equals(this.classifier, that.classifier) && Objects.equals(this.snapshotVersion, that.snapshotVersion);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.version, this.classifier, this.snapshotVersion);
    }
}

