/*
 * Decompiled with CFR 0.152.
 */
package dev.vankka.dependencydownload.path;

import dev.vankka.dependencydownload.dependency.Dependency;
import dev.vankka.dependencydownload.path.CleanupPathProvider;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class DirectoryDependencyPathProvider
implements CleanupPathProvider {
    private static final String RELOCATED_FILE_PREFIX = "relocated_";
    private final Path dependencyDirectory;

    public DirectoryDependencyPathProvider(Path dependencyDirectory) {
        this.dependencyDirectory = dependencyDirectory;
    }

    @Override
    @NotNull
    public Path getDependencyPath(@NotNull Dependency dependency, boolean relocated) {
        return this.dependencyDirectory.resolve((relocated ? RELOCATED_FILE_PREFIX : "") + dependency.getStoredFileName());
    }

    @Override
    @NotNull
    public Collection<Path> getPathsForAllStoredDependencies() throws IOException {
        try (Stream<Path> paths = Files.list(this.dependencyDirectory);){
            Collection collection = paths.collect(Collectors.toList());
            return collection;
        }
    }
}

