/*
 * Decompiled with CFR 0.152.
 */
package dev.vankka.dependencydownload.repository;

import dev.vankka.dependencydownload.dependency.Dependency;
import dev.vankka.dependencydownload.dependency.MavenDependency;
import dev.vankka.dependencydownload.repository.Repository;
import java.net.MalformedURLException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;

public class MavenRepository
implements Repository {
    private final String host;

    public MavenRepository(@NotNull String host) {
        this.host = host.endsWith("/") ? host.substring(0, host.length() - 1) : host;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public URL createURL(Dependency dependency) throws MalformedURLException {
        if (!(dependency instanceof MavenDependency)) {
            throw new IllegalArgumentException("Not a MavenDependency");
        }
        return new URL(this.getHost() + '/' + ((MavenDependency)dependency).getMavenPath());
    }
}

