/*
 * Decompiled with CFR 0.152.
 */
package dev.vankka.dependencydownload;

import dev.vankka.dependencydownload.classpath.ClasspathAppender;
import dev.vankka.dependencydownload.dependency.Dependency;
import dev.vankka.dependencydownload.dependency.SnapshotDependency;
import dev.vankka.dependencydownload.dependency.StandardDependency;
import dev.vankka.dependencydownload.relocation.JarRelocatorHelper;
import dev.vankka.dependencydownload.relocation.Relocation;
import dev.vankka.dependencydownload.repository.Repository;
import dev.vankka.dependencydownload.util.ExceptionalConsumer;
import dev.vankka.dependencydownload.util.HashUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;

public class DependencyManager {
    private static final String RELOCATED_FILE_PREFIX = "relocated_";
    private final Path cacheDirectory;
    private final List<Dependency> dependencies = new CopyOnWriteArrayList<Dependency>();
    private final Set<Relocation> relocations = new CopyOnWriteArraySet<Relocation>();
    private final AtomicInteger step = new AtomicInteger(0);

    public DependencyManager(Path cacheDirectory) {
        this.cacheDirectory = cacheDirectory;
    }

    public void addDependency(Dependency dependency) {
        this.dependencies.add(dependency);
    }

    public List<Dependency> getDependencies() {
        return Collections.unmodifiableList(this.dependencies);
    }

    public void addRelocation(Relocation relocation) {
        this.relocations.add(relocation);
    }

    public Set<Relocation> getRelocations() {
        return Collections.unmodifiableSet(this.relocations);
    }

    public void loadFromResource(URL resourceURL) throws IOException {
        List<String> lines;
        if (resourceURL == null) {
            throw new NullPointerException("resourceURL");
        }
        try (InputStream inputStream = resourceURL.openStream();){
            lines = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.toList());
        }
        this.loadFromResource(lines);
    }

    public void loadFromResource(String fileContents) {
        if (fileContents == null) {
            throw new NullPointerException("fileContents");
        }
        this.loadFromResource(Arrays.asList(fileContents.split("\n")));
    }

    public void loadFromResource(List<String> fileLines) {
        if (fileLines == null) {
            throw new NullPointerException("fileLines");
        }
        String hashingAlgorithm = null;
        int relocationStep = -1;
        String pattern = null;
        String replacement = null;
        Set<String> include = null;
        block5: for (String line : fileLines) {
            if ((line = line.trim()).isEmpty()) continue;
            if (line.startsWith("===ALGORITHM")) {
                String[] algorithmParts = line.split(" ");
                if (algorithmParts.length != 2) {
                    throw new IllegalArgumentException("Resource format is invalid: hashing algorithm: " + line);
                }
                hashingAlgorithm = algorithmParts[1];
                continue;
            }
            if (hashingAlgorithm == null) {
                throw new IllegalArgumentException("Resource format is invalid: no hashing algorithm");
            }
            if (line.startsWith("===RELOCATIONS") && relocationStep == -1) {
                relocationStep = 0;
                continue;
            }
            if (relocationStep != -1) {
                switch (relocationStep) {
                    case 0: {
                        pattern = line;
                        break;
                    }
                    case 1: {
                        replacement = line;
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (!line.startsWith("[") || !line.endsWith("]")) {
                            throw new IllegalArgumentException("Resource format is invalid: expecting a includes/excludes: " + line);
                        }
                        Set<String> values = !(line = line.substring(1, line.length() - 1)).trim().isEmpty() ? new HashSet<String>(Arrays.asList(line.split(","))) : Collections.emptySet();
                        if (relocationStep == 2) {
                            include = values;
                            break;
                        }
                        this.relocations.add(new Relocation(pattern, replacement, include, values));
                        include = null;
                        relocationStep = 0;
                        continue block5;
                    }
                }
                ++relocationStep;
                continue;
            }
            String[] parts = line.split(" ");
            if (parts.length != 2) {
                throw new IllegalArgumentException("Resource format is invalid: invalid dependency: " + line);
            }
            String maven = parts[0];
            String hash = parts[1];
            String[] mavenParts = maven.split(":");
            int partCount = mavenParts.length;
            if (partCount < 3 || partCount > 4) {
                throw new IllegalArgumentException("Resource format is invalid: invalid dependency GAV: " + maven + " (" + partCount + ")");
            }
            StandardDependency dependency = partCount == 3 ? new StandardDependency(mavenParts[0], mavenParts[1], mavenParts[2], hash, hashingAlgorithm) : new SnapshotDependency(mavenParts[0], mavenParts[1], mavenParts[2], mavenParts[3], hash, hashingAlgorithm);
            this.dependencies.add(dependency);
        }
        if (relocationStep > 1) {
            this.relocations.add(new Relocation(pattern, replacement, include, null));
        }
    }

    public CompletableFuture<Void> downloadAll(Executor executor, List<Repository> repositories) {
        return CompletableFuture.allOf(this.download(executor, repositories));
    }

    public CompletableFuture<Void>[] download(Executor executor, List<Repository> repositories) {
        if (!this.step.compareAndSet(0, 1)) {
            throw new IllegalStateException("Download has already been executed");
        }
        return this.forEachDependency(executor, dependency -> this.downloadDependency((Dependency)dependency, repositories), (dependency, cause) -> new RuntimeException("Failed to download dependency " + dependency.getMavenArtifact(), (Throwable)cause));
    }

    public CompletableFuture<Void> relocateAll(Executor executor) {
        return CompletableFuture.allOf(this.relocate(executor, this.getClass().getClassLoader()));
    }

    public CompletableFuture<Void> relocateAll(Executor executor, ClassLoader jarRelocatorLoader) {
        return CompletableFuture.allOf(this.relocate(executor, jarRelocatorLoader));
    }

    public CompletableFuture<Void>[] relocate(Executor executor) {
        return this.relocate(executor, this.getClass().getClassLoader());
    }

    public CompletableFuture<Void>[] relocate(Executor executor, ClassLoader jarRelocatorLoader) {
        int currentStep = this.step.get();
        if (currentStep == 0) {
            throw new IllegalArgumentException("Download hasn't been executed");
        }
        if (currentStep != 1) {
            throw new IllegalArgumentException("Relocate has already been executed");
        }
        this.step.set(2);
        JarRelocatorHelper helper = new JarRelocatorHelper(jarRelocatorLoader);
        return this.forEachDependency(executor, dependency -> this.relocateDependency((Dependency)dependency, helper), (dependency, cause) -> new RuntimeException("Failed to relocate dependency " + dependency.getMavenArtifact(), (Throwable)cause));
    }

    public CompletableFuture<Void> loadAll(Executor executor, ClasspathAppender classpathAppender) {
        return CompletableFuture.allOf(this.load(executor, classpathAppender));
    }

    public CompletableFuture<Void>[] load(Executor executor, ClasspathAppender classpathAppender) {
        int currentStep = this.step.get();
        if (currentStep == 0) {
            throw new IllegalArgumentException("Download hasn't been executed");
        }
        this.step.set(3);
        return this.forEachDependency(executor, dependency -> this.loadDependency((Dependency)dependency, classpathAppender, currentStep == 2), (dependency, cause) -> new RuntimeException("Failed to load dependency " + dependency.getMavenArtifact(), (Throwable)cause));
    }

    public Path getPathForDependency(Dependency dependency) {
        String fileName = dependency.getStoredFileName();
        return this.cacheDirectory.resolve(fileName);
    }

    public Path getRelocatedPathForDependency(Dependency dependency) {
        String fileName = dependency.getStoredFileName();
        return this.cacheDirectory.resolve(RELOCATED_FILE_PREFIX + fileName);
    }

    public Set<Path> getAllPaths(boolean includeRelocated) {
        HashSet<Path> paths = new HashSet<Path>();
        for (Dependency dependency : this.dependencies) {
            paths.add(this.getPathForDependency(dependency));
            if (!includeRelocated) continue;
            paths.add(this.getRelocatedPathForDependency(dependency));
        }
        return paths;
    }

    private CompletableFuture<Void>[] forEachDependency(Executor executor, ExceptionalConsumer<Dependency> runnable, BiFunction<Dependency, Throwable, Throwable> dependencyException) {
        int size = this.dependencies.size();
        CompletableFuture[] futures = new CompletableFuture[size];
        for (int index = 0; index < size; ++index) {
            Dependency dependency = this.dependencies.get(index);
            CompletableFuture future = new CompletableFuture();
            Runnable run = () -> {
                try {
                    runnable.run(dependency);
                    future.complete(null);
                }
                catch (Throwable t) {
                    future.completeExceptionally((Throwable)dependencyException.apply(dependency, t));
                }
            };
            if (executor != null) {
                executor.execute(run);
            } else {
                run.run();
            }
            futures[index] = future;
            if (future.isCompletedExceptionally()) break;
        }
        return futures;
    }

    private void downloadDependency(Dependency dependency, List<Repository> repositories) throws IOException, NoSuchAlgorithmException {
        Path dependencyPath;
        if (!this.cacheDirectory.toFile().exists()) {
            Files.createDirectories(this.cacheDirectory, new FileAttribute[0]);
        }
        if (Files.exists(dependencyPath = this.getPathForDependency(dependency), new LinkOption[0])) {
            String fileHash = HashUtil.getFileHash((File)dependencyPath.toFile(), (String)dependency.getHashingAlgorithm());
            if (fileHash.equals(dependency.getHash())) {
                return;
            }
            Files.delete(dependencyPath);
        }
        Files.createFile(dependencyPath, new FileAttribute[0]);
        RuntimeException failure = new RuntimeException("All provided repositories failed to download dependency");
        for (Repository repository : repositories) {
            try {
                MessageDigest digest = MessageDigest.getInstance(dependency.getHashingAlgorithm());
                this.downloadFromRepository(dependency, repository, dependencyPath, digest);
                String hash = HashUtil.getHash((MessageDigest)digest);
                String dependencyHash = dependency.getHash();
                if (!hash.equals(dependencyHash)) {
                    throw new RuntimeException("Failed to verify file hash: " + hash + " should've been: " + dependencyHash);
                }
                return;
            }
            catch (Throwable e) {
                Files.deleteIfExists(dependencyPath);
                failure.addSuppressed(e);
            }
        }
        throw failure;
    }

    private void downloadFromRepository(Dependency dependency, Repository repository, Path dependencyPath, MessageDigest digest) throws Throwable {
        HttpsURLConnection connection = repository.openConnection(dependency);
        byte[] buffer = new byte[4096];
        try (BufferedInputStream inputStream = new BufferedInputStream(connection.getInputStream());
             BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(dependencyPath.toFile()));){
            int total;
            while ((total = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, total);
                digest.update(buffer, 0, total);
            }
        }
    }

    private void relocateDependency(Dependency dependency, JarRelocatorHelper helper) {
        Path dependencyFile = this.getPathForDependency(dependency);
        Path relocatedFile = this.getRelocatedPathForDependency(dependency);
        try {
            helper.run(dependencyFile, relocatedFile, this.relocations);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Failed to run relocation", e.getCause());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Failed to initialize relocator", e);
        }
    }

    private void loadDependency(Dependency dependency, ClasspathAppender classpathAppender, boolean relocated) throws MalformedURLException {
        Path fileToLoad = relocated ? this.getRelocatedPathForDependency(dependency) : this.getPathForDependency(dependency);
        classpathAppender.appendFileToClasspath(fileToLoad);
    }
}

