/*
 * Decompiled with CFR 0.152.
 */
package dev.vankka.dependencydownload.dependency;

public interface Dependency {
    public static final String MAVEN_PATH_FORMAT = "%s/%s/%s/%s";

    public String getGroupId();

    public String getArtifactId();

    public String getVersion();

    public String getSnapshotVersion();

    public String getHash();

    public String getHashingAlgorithm();

    public boolean isSnapshot();

    default public String getFileName() {
        return this.getArtifactId() + '-' + this.getVersion() + ".jar";
    }

    default public String getStoredFileName() {
        return this.getGroupId() + '-' + this.getArtifactId() + '-' + this.getVersion() + ".jar";
    }

    default public String getMavenPath() {
        return String.format(MAVEN_PATH_FORMAT, this.getGroupId().replace('.', '/'), this.getArtifactId(), this.getVersion(), this.getFileName());
    }

    default public String getMavenArtifact() {
        return this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getVersion();
    }
}

