/*
 * Decompiled with CFR 0.152.
 */
package dev.vankka.dependencydownload.dependency;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Dependency {
    public static final String MAVEN_PATH_FORMAT = "%s/%s/%s/%s";

    @NotNull
    public String getGroupId();

    @NotNull
    public String getArtifactId();

    @NotNull
    public String getVersion();

    @Nullable
    public String getClassifier();

    @Nullable
    public String getSnapshotVersion();

    @NotNull
    public String getHash();

    @NotNull
    public String getHashingAlgorithm();

    public boolean isSnapshot();

    @NotNull
    default public String getFileName() {
        return this.getArtifactId() + '-' + this.getVersion() + ".jar";
    }

    @NotNull
    default public String getStoredFileName() {
        String classifier = this.getClassifier();
        return this.getGroupId() + '-' + this.getArtifactId() + '-' + this.getVersion() + (classifier != null ? '-' + classifier : "") + ".jar";
    }

    @NotNull
    default public String getMavenPath() {
        return String.format(MAVEN_PATH_FORMAT, this.getGroupId().replace('.', '/'), this.getArtifactId(), this.getVersion(), this.getFileName());
    }

    @NotNull
    default public String getMavenArtifact() {
        String classifier = this.getClassifier();
        return this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getVersion() + (classifier != null ? ":" + classifier : "");
    }
}

