/*
 * Decompiled with CFR 0.152.
 */
package dev.vankka.mcdependencydownload.bukkit.loader;

import dev.vankka.dependencydownload.jarinjar.classloader.JarInJarClassLoader;
import dev.vankka.dependencydownload.jarinjar.loader.ILoader;
import dev.vankka.mcdependencydownload.bukkit.bootstrap.IBukkitBootstrap;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Optional;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public abstract class BukkitLoader
extends JavaPlugin
implements ILoader {
    protected final JarInJarClassLoader classLoader = this.initialize();
    private IBukkitBootstrap bootstrap;

    private Optional<IBukkitBootstrap> bootstrap() {
        return Optional.ofNullable(this.bootstrap);
    }

    public final JarInJarClassLoader initialize() {
        return super.initialize();
    }

    public final void initiateBootstrap(Class<?> bootstrapClass, @NotNull JarInJarClassLoader classLoader) throws ReflectiveOperationException {
        Constructor<?> constructor = bootstrapClass.getConstructor(JarInJarClassLoader.class, JavaPlugin.class);
        this.bootstrap = (IBukkitBootstrap)constructor.newInstance(new Object[]{classLoader, this});
    }

    @NotNull
    public final ClassLoader getParentClassLoader() {
        return this.getClassLoader();
    }

    public final void onLoad() {
        this.bootstrap().ifPresent(IBukkitBootstrap::onLoad);
    }

    public final void onEnable() {
        this.bootstrap().ifPresent(IBukkitBootstrap::onEnable);
    }

    public final void onDisable() {
        this.bootstrap().ifPresent(IBukkitBootstrap::onDisable);
        this.close();
    }

    protected void close() {
        try {
            this.classLoader.close();
        }
        catch (IOException e) {
            this.getLogger().severe("Failed to close JarInJarClassLoader");
            e.printStackTrace();
        }
    }
}

