/*
 * Decompiled with CFR 0.152.
 */
package dev.vicart.kotp.hotp;

import dev.vicart.kotp.common.HashAlgorithm;
import dev.vicart.kotp.extension.NumberToBytesKt;
import java.nio.ByteBuffer;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.codec.binary.Base32;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0016H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006\u0019"}, d2={"Ldev/vicart/kotp/hotp/HOTPGenerator;", "", "codeLength", "", "algorithm", "Ldev/vicart/kotp/common/HashAlgorithm;", "<init>", "(ILdev/vicart/kotp/common/HashAlgorithm;)V", "getCodeLength", "()I", "getAlgorithm", "()Ldev/vicart/kotp/common/HashAlgorithm;", "hmac", "Ljavax/crypto/Mac;", "kotlin.jvm.PlatformType", "Ljavax/crypto/Mac;", "generateCode", "", "key", "Ljavax/crypto/SecretKey;", "counter", "", "", "getCodeFromHash", "hash", "kotp"})
public final class HOTPGenerator {
    private final int codeLength;
    @NotNull
    private final HashAlgorithm algorithm;
    private final Mac hmac;

    public HOTPGenerator(int codeLength, @NotNull HashAlgorithm algorithm) {
        Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
        this.codeLength = codeLength;
        this.algorithm = algorithm;
        this.hmac = Mac.getInstance("Hmac" + this.algorithm.name());
    }

    public /* synthetic */ HOTPGenerator(int n, HashAlgorithm hashAlgorithm, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 6;
        }
        if ((n2 & 2) != 0) {
            hashAlgorithm = HashAlgorithm.SHA1;
        }
        this(n, hashAlgorithm);
    }

    public final int getCodeLength() {
        return this.codeLength;
    }

    @NotNull
    public final HashAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    @NotNull
    public final String generateCode(@NotNull SecretKey key, long counter) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.hmac.reset();
        this.hmac.init(key);
        byte[] hmacResult = this.hmac.doFinal(NumberToBytesKt.toByteArray(counter));
        Intrinsics.checkNotNull((Object)hmacResult);
        return this.getCodeFromHash(hmacResult);
    }

    @NotNull
    public final String generateCode(@NotNull byte[] key, long counter) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SecretKeySpec secretKey = new SecretKeySpec(key, this.algorithm.name());
        return this.generateCode(secretKey, counter);
    }

    @NotNull
    public final String generateCode(@NotNull String key, long counter) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        byte[] baseKey = new Base32().decode(key);
        Intrinsics.checkNotNull((Object)baseKey);
        return this.generateCode(baseKey, counter);
    }

    private final String getCodeFromHash(byte[] hash) {
        int truncated;
        byte lastByte;
        int mask = 15;
        byte offset = lastByte = (byte)(ArraysKt.last((byte[])hash) & mask);
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.put(hash, offset, 4);
        int n = truncated = byteBuffer.position(0).getInt() & Integer.MAX_VALUE;
        int n2 = (int)Math.pow(10.0f, this.codeLength);
        int n3 = n % n2;
        truncated = n3 + (n2 & ((n3 ^ n2) & (n3 | -n3)) >> 31);
        return StringsKt.padStart((String)String.valueOf(truncated), (int)this.codeLength, (char)'0');
    }

    public HOTPGenerator() {
        this(0, null, 3, null);
    }
}

