/*
 * Decompiled with CFR 0.152.
 */
package dev.vicart.kotp.hotp;

import dev.vicart.kotp.common.HashAlgorithm;
import dev.vicart.kotp.hotp.HOTPGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.codec.binary.Base32;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Ldev/vicart/kotp/hotp/HOTPVerifier;", "", "algorithm", "Ldev/vicart/kotp/common/HashAlgorithm;", "<init>", "(Ldev/vicart/kotp/common/HashAlgorithm;)V", "getAlgorithm", "()Ldev/vicart/kotp/common/HashAlgorithm;", "verify", "", "key", "Ljavax/crypto/SecretKey;", "code", "", "counter", "", "", "kotp"})
public final class HOTPVerifier {
    @NotNull
    private final HashAlgorithm algorithm;

    public HOTPVerifier(@NotNull HashAlgorithm algorithm) {
        Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
        this.algorithm = algorithm;
    }

    public /* synthetic */ HOTPVerifier(HashAlgorithm hashAlgorithm, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            hashAlgorithm = HashAlgorithm.SHA1;
        }
        this(hashAlgorithm);
    }

    @NotNull
    public final HashAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public final boolean verify(@NotNull SecretKey key, @NotNull String code, long counter) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        HOTPGenerator hotpGenerator = new HOTPGenerator(code.length(), this.algorithm);
        return Intrinsics.areEqual((Object)hotpGenerator.generateCode(key, counter), (Object)code);
    }

    public final boolean verify(@NotNull byte[] key, @NotNull String code, long counter) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        SecretKeySpec secretKey = new SecretKeySpec(key, this.algorithm.name());
        return this.verify(secretKey, code, counter);
    }

    public final boolean verify(@NotNull String key, @NotNull String code, long counter) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        byte[] secretKey = new Base32().decode(key);
        Intrinsics.checkNotNull((Object)secretKey);
        return this.verify(secretKey, code, counter);
    }

    public HOTPVerifier() {
        this(null, 1, null);
    }
}

