/*
 * Decompiled with CFR 0.152.
 */
package dev.vicart.kotp.totp;

import dev.vicart.kotp.common.HashAlgorithm;
import dev.vicart.kotp.hotp.HOTPGenerator;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import javax.crypto.SecretKey;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001c2\b\b\u0002\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\b\b\u0002\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015\u00a8\u0006\u001e"}, d2={"Ldev/vicart/kotp/totp/TOTPGenerator;", "", "codeLength", "", "algorithm", "Ldev/vicart/kotp/common/HashAlgorithm;", "periodSecond", "", "<init>", "(ILdev/vicart/kotp/common/HashAlgorithm;J)V", "getCodeLength", "()I", "getAlgorithm", "()Ldev/vicart/kotp/common/HashAlgorithm;", "getPeriodSecond", "()J", "hotpGenerator", "Ldev/vicart/kotp/hotp/HOTPGenerator;", "period", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "Ljava/time/Duration;", "generateCode", "", "key", "Ljavax/crypto/SecretKey;", "instant", "Ljava/time/Instant;", "", "getCounterFrom", "kotp"})
public final class TOTPGenerator {
    private final int codeLength;
    @NotNull
    private final HashAlgorithm algorithm;
    private final long periodSecond;
    @NotNull
    private final HOTPGenerator hotpGenerator;
    private final Duration period;

    public TOTPGenerator(int codeLength, @NotNull HashAlgorithm algorithm, long periodSecond) {
        Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
        this.codeLength = codeLength;
        this.algorithm = algorithm;
        this.periodSecond = periodSecond;
        this.hotpGenerator = new HOTPGenerator(this.codeLength, this.algorithm);
        this.period = Duration.of(this.periodSecond, ChronoUnit.SECONDS);
    }

    public /* synthetic */ TOTPGenerator(int n, HashAlgorithm hashAlgorithm, long l, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 6;
        }
        if ((n2 & 2) != 0) {
            hashAlgorithm = HashAlgorithm.SHA1;
        }
        if ((n2 & 4) != 0) {
            l = 30L;
        }
        this(n, hashAlgorithm, l);
    }

    public final int getCodeLength() {
        return this.codeLength;
    }

    @NotNull
    public final HashAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public final long getPeriodSecond() {
        return this.periodSecond;
    }

    @NotNull
    public final String generateCode(@NotNull SecretKey key, @NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        long counter = this.getCounterFrom(instant);
        return this.hotpGenerator.generateCode(key, counter);
    }

    public static /* synthetic */ String generateCode$default(TOTPGenerator tOTPGenerator, SecretKey secretKey, Instant instant, int n, Object object) {
        if ((n & 2) != 0) {
            instant = Instant.now();
        }
        return tOTPGenerator.generateCode(secretKey, instant);
    }

    @NotNull
    public final String generateCode(@NotNull byte[] key, @NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        long counter = this.getCounterFrom(instant);
        return this.hotpGenerator.generateCode(key, counter);
    }

    public static /* synthetic */ String generateCode$default(TOTPGenerator tOTPGenerator, byte[] byArray, Instant instant, int n, Object object) {
        if ((n & 2) != 0) {
            instant = Instant.now();
        }
        return tOTPGenerator.generateCode(byArray, instant);
    }

    @NotNull
    public final String generateCode(@NotNull String key, @NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        long counter = this.getCounterFrom(instant);
        return this.hotpGenerator.generateCode(key, counter);
    }

    public static /* synthetic */ String generateCode$default(TOTPGenerator tOTPGenerator, String string, Instant instant, int n, Object object) {
        if ((n & 2) != 0) {
            instant = Instant.now();
        }
        return tOTPGenerator.generateCode(string, instant);
    }

    private final long getCounterFrom(Instant instant) {
        return instant.getEpochSecond() / this.period.getSeconds();
    }

    public TOTPGenerator() {
        this(0, null, 0L, 7, null);
    }
}

