/*
 * Decompiled with CFR 0.152.
 */
package dev.vicart.kotp.totp;

import dev.vicart.kotp.common.HashAlgorithm;
import dev.vicart.kotp.totp.TOTPGenerator;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.LongIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongProgression;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import org.apache.commons.codec.binary.Base32;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Ldev/vicart/kotp/totp/TOTPVerifier;", "", "algorithm", "Ldev/vicart/kotp/common/HashAlgorithm;", "period", "", "<init>", "(Ldev/vicart/kotp/common/HashAlgorithm;J)V", "getAlgorithm", "()Ldev/vicart/kotp/common/HashAlgorithm;", "getPeriod", "()J", "verify", "", "key", "Ljavax/crypto/SecretKey;", "code", "", "instant", "Ljava/time/Instant;", "", "kotp"})
@SourceDebugExtension(value={"SMAP\nTOTPVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TOTPVerifier.kt\ndev/vicart/kotp/totp/TOTPVerifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,27:1\n1557#2:28\n1628#2,3:29\n*S KotlinDebug\n*F\n+ 1 TOTPVerifier.kt\ndev/vicart/kotp/totp/TOTPVerifier\n*L\n13#1:28\n13#1:29,3\n*E\n"})
public final class TOTPVerifier {
    @NotNull
    private final HashAlgorithm algorithm;
    private final long period;

    public TOTPVerifier(@NotNull HashAlgorithm algorithm, long period) {
        Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
        this.algorithm = algorithm;
        this.period = period;
    }

    public /* synthetic */ TOTPVerifier(HashAlgorithm hashAlgorithm, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            hashAlgorithm = HashAlgorithm.SHA1;
        }
        if ((n & 2) != 0) {
            l = 30L;
        }
        this(hashAlgorithm, l);
    }

    @NotNull
    public final HashAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public final long getPeriod() {
        return this.period;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean verify(@NotNull SecretKey key, @NotNull String code, @NotNull Instant instant) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        TOTPGenerator totpGenerator = new TOTPGenerator(code.length(), this.algorithm, this.period);
        Iterable $this$map$iv = (Iterable)RangesKt.step((LongProgression)((LongProgression)new LongRange(instant.minusSeconds(this.period).getEpochSecond(), instant.plusSeconds(this.period).getEpochSecond())), (long)this.period);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            long item$iv$iv;
            long l = item$iv$iv = ((LongIterator)iterator).nextLong();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Instant instant2 = Instant.ofEpochSecond((long)it);
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"ofEpochSecond(...)");
            collection.add(Intrinsics.areEqual((Object)totpGenerator.generateCode(key, instant2), (Object)code));
        }
        return ((List)destination$iv$iv).contains(true);
    }

    public static /* synthetic */ boolean verify$default(TOTPVerifier tOTPVerifier, SecretKey secretKey, String string, Instant instant, int n, Object object) {
        if ((n & 4) != 0) {
            instant = Instant.now();
        }
        return tOTPVerifier.verify(secretKey, string, instant);
    }

    public final boolean verify(@NotNull byte[] key, @NotNull String code, @NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        SecretKeySpec secretKey = new SecretKeySpec(key, this.algorithm.name());
        return this.verify(secretKey, code, instant);
    }

    public static /* synthetic */ boolean verify$default(TOTPVerifier tOTPVerifier, byte[] byArray, String string, Instant instant, int n, Object object) {
        if ((n & 4) != 0) {
            instant = Instant.now();
        }
        return tOTPVerifier.verify(byArray, string, instant);
    }

    public final boolean verify(@NotNull String key, @NotNull String code, @NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        byte[] secretKey = new Base32().decode(key);
        Intrinsics.checkNotNull((Object)secretKey);
        return this.verify(secretKey, code, instant);
    }

    public static /* synthetic */ boolean verify$default(TOTPVerifier tOTPVerifier, String string, String string2, Instant instant, int n, Object object) {
        if ((n & 4) != 0) {
            instant = Instant.now();
        }
        return tOTPVerifier.verify(string, string2, instant);
    }

    public TOTPVerifier() {
        this(null, 0L, 3, null);
    }
}

