/*
 * Decompiled with CFR 0.152.
 */
package dev.vortex.api;

import java.util.List;
import java.util.Optional;

public interface DType
extends AutoCloseable {
    public Variant getVariant();

    public boolean isNullable();

    public List<String> getFieldNames();

    public List<DType> getFieldTypes();

    public DType getElementType();

    public boolean isDate();

    public boolean isTime();

    public boolean isTimestamp();

    public TimeUnit getTimeUnit();

    public Optional<String> getTimeZone();

    public boolean isDecimal();

    public int getPrecision();

    public byte getScale();

    @Override
    public void close();

    public static enum Variant {
        NULL,
        BOOL,
        PRIMITIVE_U8,
        PRIMITIVE_U16,
        PRIMITIVE_U32,
        PRIMITIVE_U64,
        PRIMITIVE_I8,
        PRIMITIVE_I16,
        PRIMITIVE_I32,
        PRIMITIVE_I64,
        PRIMITIVE_F16,
        PRIMITIVE_F32,
        PRIMITIVE_F64,
        UTF8,
        BINARY,
        STRUCT,
        LIST,
        EXTENSION,
        DECIMAL;


        public static Variant from(byte variant) {
            switch (variant) {
                case 0: {
                    return NULL;
                }
                case 1: {
                    return BOOL;
                }
                case 2: {
                    return PRIMITIVE_U8;
                }
                case 3: {
                    return PRIMITIVE_U16;
                }
                case 4: {
                    return PRIMITIVE_U32;
                }
                case 5: {
                    return PRIMITIVE_U64;
                }
                case 6: {
                    return PRIMITIVE_I8;
                }
                case 7: {
                    return PRIMITIVE_I16;
                }
                case 8: {
                    return PRIMITIVE_I32;
                }
                case 9: {
                    return PRIMITIVE_I64;
                }
                case 10: {
                    return PRIMITIVE_F16;
                }
                case 11: {
                    return PRIMITIVE_F32;
                }
                case 12: {
                    return PRIMITIVE_F64;
                }
                case 13: {
                    return UTF8;
                }
                case 14: {
                    return BINARY;
                }
                case 15: {
                    return STRUCT;
                }
                case 16: {
                    return LIST;
                }
                case 17: {
                    return EXTENSION;
                }
                case 18: {
                    return DECIMAL;
                }
            }
            throw new IllegalArgumentException("Unknown DType variant: " + variant);
        }
    }

    public static enum TimeUnit {
        NANOSECONDS,
        MICROSECONDS,
        MILLISECONDS,
        SECONDS,
        DAYS;


        public static TimeUnit from(byte unit) {
            switch (unit) {
                case 0: {
                    return NANOSECONDS;
                }
                case 1: {
                    return MICROSECONDS;
                }
                case 2: {
                    return MILLISECONDS;
                }
                case 3: {
                    return SECONDS;
                }
                case 4: {
                    return DAYS;
                }
            }
            throw new IllegalArgumentException("Unknown TimeUnit: " + unit);
        }
    }
}

