/*
 * Decompiled with CFR 0.152.
 */
package dev.vortex.api;

import dev.vortex.api.File;
import dev.vortex.jni.JNIFile;
import dev.vortex.jni.NativeFileMethods;
import dev.vortex.relocated.com.google.common.base.Preconditions;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Map;

public final class Files {
    private Files() {
    }

    public static File open(String path) {
        if (path.startsWith("/")) {
            return Files.open(Paths.get(path, new String[0]).toUri(), Map.of());
        }
        return Files.open(URI.create(path), Map.of());
    }

    public static File open(URI uri, Map<String, String> properties) {
        long ptr = NativeFileMethods.open(uri.toString(), properties);
        Preconditions.checkArgument(ptr > 0L, "Failed to open file: %s", (Object)uri);
        return new JNIFile(ptr);
    }
}

